/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.firewall;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionLogger;
import org.apache.mina.common.WriteRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlacklistFilter
extends IoFilterAdapter {
    private final List<InetAddress> blacklist = new CopyOnWriteArrayList<InetAddress>();

    public void setBlacklist(InetAddress[] addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            this.block(addr, "addresses[" + i + ']');
        }
    }

    public void setBlacklist(Iterable<InetAddress> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (InetAddress address : addresses) {
            this.block(address, address.getHostName());
        }
    }

    public void block(InetAddress address, String error_string) {
        if (address == null) {
            throw new NullPointerException(error_string);
        }
        this.blacklist.add(address);
    }

    public void block(InetAddress address) {
        this.block(address, "address");
    }

    public void unblock(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.blacklist.remove(address);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        if (!this.isBlocked(session)) {
            nextFilter.sessionCreated(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionOpened(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionClosed(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionIdle(session, status);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (!this.isBlocked(session)) {
            nextFilter.messageReceived(session, message);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.messageSent(session, writeRequest);
        } else {
            this.blockSession(session);
        }
    }

    private void blockSession(IoSession session) {
        IoSessionLogger.getLogger(session, this.getClass()).warn("Remote address in the blacklist; closing.");
        session.close();
    }

    private boolean isBlocked(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        return remoteAddress instanceof InetSocketAddress && this.blacklist.contains(((InetSocketAddress)remoteAddress).getAddress());
    }
}

