/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.statistic;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoEventType;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.util.CopyOnWriteMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerTimerFilter
extends IoFilterAdapter {
    private volatile EnumSet<IoEventType> eventsToProfile;
    private volatile ProfilerTimerUnit timeUnit;
    private final Map<IoEventType, TimerWorker> timerManager;

    public ProfilerTimerFilter() {
        this(TimeUnit.MILLISECONDS, EnumSet.of(IoEventType.MESSAGE_RECEIVED, IoEventType.MESSAGE_SENT));
    }

    public ProfilerTimerFilter(TimeUnit unit) {
        this(unit, IoEventType.MESSAGE_RECEIVED, IoEventType.MESSAGE_SENT);
    }

    public ProfilerTimerFilter(TimeUnit unit, IoEventType firstEventType, IoEventType ... otherEventTypes) {
        this(unit, EnumSet.of(firstEventType, otherEventTypes));
    }

    public ProfilerTimerFilter(TimeUnit unit, EnumSet<IoEventType> eventTypes) {
        this.setTimeUnit(unit);
        this.setEventsToProfile(eventTypes);
        this.timerManager = new CopyOnWriteMap<IoEventType, TimerWorker>();
        for (IoEventType type : this.eventsToProfile) {
            this.timerManager.put(type, new TimerWorker());
        }
    }

    public void setTimeUnit(TimeUnit unit) {
        if (unit == TimeUnit.MILLISECONDS) {
            this.timeUnit = ProfilerTimerUnit.MILLISECONDS;
        } else if (unit == TimeUnit.NANOSECONDS) {
            this.timeUnit = ProfilerTimerUnit.NANOSECONDS;
        } else if (unit == TimeUnit.SECONDS) {
            this.timeUnit = ProfilerTimerUnit.SECONDS;
        } else {
            throw new IllegalArgumentException("Invalid Time specified: " + (Object)((Object)unit) + " (expected: " + (Object)((Object)TimeUnit.MILLISECONDS) + ", " + (Object)((Object)TimeUnit.NANOSECONDS) + " or " + (Object)((Object)TimeUnit.SECONDS) + ')');
        }
    }

    public void addEventToProfile(IoEventType type) {
        if (!this.timerManager.containsKey((Object)type)) {
            this.timerManager.put(type, new TimerWorker());
        }
    }

    public void removeEventToProfile(IoEventType type) {
        this.timerManager.remove((Object)type);
    }

    public Set<IoEventType> getEventsToProfile() {
        return Collections.unmodifiableSet(this.eventsToProfile);
    }

    public void setEventsToProfile(IoEventType firstEventType, IoEventType ... otherEventTypes) {
        this.setEventsToProfile(EnumSet.of(firstEventType, otherEventTypes));
    }

    public void setEventsToProfile(Set<IoEventType> eventTypes) {
        if (eventTypes == null) {
            throw new NullPointerException("eventTypes");
        }
        if (eventTypes.isEmpty()) {
            throw new IllegalArgumentException("eventTypes is empty.");
        }
        EnumSet<IoEventType> newEventsToProfile = EnumSet.noneOf(IoEventType.class);
        for (IoEventType e : eventTypes) {
            newEventsToProfile.add(e);
        }
        this.eventsToProfile = newEventsToProfile;
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        long start = this.timeUnit.timeNow();
        nextFilter.messageReceived(session, message);
        long end = this.timeUnit.timeNow();
        if (this.getEventsToProfile().contains((Object)IoEventType.MESSAGE_RECEIVED)) {
            this.timerManager.get((Object)IoEventType.MESSAGE_RECEIVED).addNewReading(end - start);
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        long start = this.timeUnit.timeNow();
        nextFilter.messageSent(session, writeRequest);
        long end = this.timeUnit.timeNow();
        if (this.getEventsToProfile().contains((Object)IoEventType.MESSAGE_SENT)) {
            this.timerManager.get((Object)IoEventType.MESSAGE_SENT).addNewReading(end - start);
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        long start = this.timeUnit.timeNow();
        nextFilter.sessionClosed(session);
        long end = this.timeUnit.timeNow();
        if (this.getEventsToProfile().contains((Object)IoEventType.SESSION_CLOSED)) {
            this.timerManager.get((Object)IoEventType.SESSION_CLOSED).addNewReading(end - start);
        }
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        long start = this.timeUnit.timeNow();
        nextFilter.sessionCreated(session);
        long end = this.timeUnit.timeNow();
        if (this.getEventsToProfile().contains((Object)IoEventType.SESSION_CREATED)) {
            this.timerManager.get((Object)IoEventType.SESSION_CREATED).addNewReading(end - start);
        }
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        long start = this.timeUnit.timeNow();
        nextFilter.sessionIdle(session, status);
        long end = this.timeUnit.timeNow();
        if (this.getEventsToProfile().contains((Object)IoEventType.SESSION_IDLE)) {
            this.timerManager.get((Object)IoEventType.SESSION_IDLE).addNewReading(end - start);
        }
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        long start = this.timeUnit.timeNow();
        nextFilter.sessionOpened(session);
        long end = this.timeUnit.timeNow();
        if (this.getEventsToProfile().contains((Object)IoEventType.SESSION_OPENED)) {
            this.timerManager.get((Object)IoEventType.SESSION_OPENED).addNewReading(end - start);
        }
    }

    public double getAverageTime(IoEventType type) {
        if (!this.timerManager.containsKey((Object)type)) {
            throw new IllegalArgumentException("You are not monitoring this event.  Please add this event first.");
        }
        return this.timerManager.get((Object)type).getAverage();
    }

    public long getTotalCalls(IoEventType type) {
        if (!this.timerManager.containsKey((Object)type)) {
            throw new IllegalArgumentException("You are not monitoring this event.  Please add this event first.");
        }
        return this.timerManager.get((Object)type).getCalls();
    }

    public long getTotalTime(IoEventType type) {
        if (!this.timerManager.containsKey((Object)type)) {
            throw new IllegalArgumentException("You are not monitoring this event.  Please add this event first.");
        }
        return this.timerManager.get((Object)type).getTotal();
    }

    public long getMinimumTime(IoEventType type) {
        if (!this.timerManager.containsKey((Object)type)) {
            throw new IllegalArgumentException("You are not monitoring this event.  Please add this event first.");
        }
        return this.timerManager.get((Object)type).getMinimum();
    }

    public long getMaximumTime(IoEventType type) {
        if (!this.timerManager.containsKey((Object)type)) {
            throw new IllegalArgumentException("You are not monitoring this event.  Please add this event first.");
        }
        return this.timerManager.get((Object)type).getMaximum();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProfilerTimerUnit {
        SECONDS{

            public long timeNow() {
                return System.currentTimeMillis() / 1000L;
            }

            public String getDescription() {
                return "seconds";
            }
        }
        ,
        MILLISECONDS{

            public long timeNow() {
                return System.currentTimeMillis();
            }

            public String getDescription() {
                return "milliseconds";
            }
        }
        ,
        NANOSECONDS{

            public long timeNow() {
                return System.nanoTime();
            }

            public String getDescription() {
                return "nanoseconds";
            }
        };


        public long timeNow() {
            throw new AbstractMethodError();
        }

        public String getDescription() {
            throw new AbstractMethodError();
        }
    }

    private class TimerWorker {
        private final AtomicLong total;
        private final AtomicLong calls;
        private final AtomicLong minimum;
        private final AtomicLong maximum;
        private final Object lock = new Object();

        public TimerWorker() {
            this.total = new AtomicLong();
            this.calls = new AtomicLong();
            this.minimum = new AtomicLong();
            this.maximum = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewReading(long newReading) {
            this.calls.incrementAndGet();
            this.total.addAndGet(newReading);
            Object object = this.lock;
            synchronized (object) {
                if (newReading < this.minimum.longValue()) {
                    this.minimum.set(newReading);
                }
                if (newReading > this.maximum.longValue()) {
                    this.maximum.set(newReading);
                }
            }
        }

        public double getAverage() {
            return this.total.longValue() / this.calls.longValue();
        }

        public long getCalls() {
            return this.calls.longValue();
        }

        public long getTotal() {
            return this.total.longValue();
        }

        public long getMinimum() {
            return this.minimum.longValue();
        }

        public long getMaximum() {
            return this.maximum.longValue();
        }
    }
}

