/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.AbstractPollingIoProcessor;
import org.apache.mina.common.FileRegion;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.RuntimeIoException;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioProcessor
extends AbstractPollingIoProcessor<NioSession> {
    private final Selector selector = NioProcessor.newSelector();

    private static Selector newSelector() {
        try {
            return Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeIoException("Failed to open a selector.", e);
        }
    }

    public NioProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected void dispose0() throws Exception {
        this.selector.close();
    }

    @Override
    protected boolean select(int timeout) throws Exception {
        return this.selector.select(1000L) > 0;
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    @Override
    protected Iterator<NioSession> allSessions() {
        return new IoSessionIterator(this.selector.keys());
    }

    @Override
    protected Iterator<NioSession> selectedSessions() {
        return new IoSessionIterator(this.selector.selectedKeys());
    }

    @Override
    protected void init(NioSession session) throws Exception {
        SelectableChannel ch = (SelectableChannel)((Object)session.getChannel());
        ch.configureBlocking(false);
        session.setSelectionKey(ch.register(this.selector, 1, session));
    }

    @Override
    protected void destroy(NioSession session) throws Exception {
        ByteChannel ch = session.getChannel();
        SelectionKey key = session.getSelectionKey();
        if (key != null) {
            key.cancel();
        }
        ch.close();
    }

    @Override
    protected AbstractPollingIoProcessor.SessionState state(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            return AbstractPollingIoProcessor.SessionState.PREPARING;
        }
        return key.isValid() ? AbstractPollingIoProcessor.SessionState.OPEN : AbstractPollingIoProcessor.SessionState.CLOSED;
    }

    @Override
    protected boolean isReadable(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && key.isReadable();
    }

    @Override
    protected boolean isWritable(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && key.isWritable();
    }

    @Override
    protected boolean isInterestedInRead(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && (key.interestOps() & 1) != 0;
    }

    @Override
    protected boolean isInterestedInWrite(NioSession session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && (key.interestOps() & 4) != 0;
    }

    @Override
    protected void setInterestedInRead(NioSession session, boolean value) throws Exception {
        SelectionKey key = session.getSelectionKey();
        if (value) {
            key.interestOps(key.interestOps() | 1);
        } else {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
        }
    }

    @Override
    protected void setInterestedInWrite(NioSession session, boolean value) throws Exception {
        SelectionKey key = session.getSelectionKey();
        if (value) {
            key.interestOps(key.interestOps() | 4);
        } else {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
    }

    @Override
    protected int read(NioSession session, IoBuffer buf) throws Exception {
        return session.getChannel().read(buf.buf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int write(NioSession session, IoBuffer buf, int length) throws Exception {
        if (buf.remaining() <= length) {
            return session.getChannel().write(buf.buf());
        }
        int oldLimit = buf.limit();
        buf.limit(buf.position() + length);
        try {
            int n = session.getChannel().write(buf.buf());
            return n;
        }
        finally {
            buf.limit(oldLimit);
        }
    }

    @Override
    protected int transferFile(NioSession session, FileRegion region, int length) throws Exception {
        return (int)region.getFileChannel().transferTo(region.getPosition(), region.getCount(), session.getChannel());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IoSessionIterator
    implements Iterator<NioSession> {
        private final Iterator<SelectionKey> i;

        private IoSessionIterator(Set<SelectionKey> keys) {
            this.i = keys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public NioSession next() {
            SelectionKey key = this.i.next();
            return (NioSession)key.attachment();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

