/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.DefaultIoFilterChain;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoEvent;
import org.apache.mina.common.IoEventType;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.common.WriteRequestQueue;
import org.apache.mina.common.WriteToClosedSessionException;
import org.apache.mina.transport.vmpipe.VmPipeSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VmPipeFilterChain
extends DefaultIoFilterChain {
    private final Queue<IoEvent> eventQueue = new ConcurrentLinkedQueue<IoEvent>();
    private final IoProcessor<VmPipeSessionImpl> processor = new VmPipeIoProcessor();
    private volatile boolean flushEnabled;
    private volatile boolean sessionOpened;

    VmPipeFilterChain(AbstractIoSession session) {
        super(session);
    }

    IoProcessor<VmPipeSessionImpl> getProcessor() {
        return this.processor;
    }

    public void start() {
        this.flushEnabled = true;
        this.flushEvents();
        VmPipeFilterChain.flushPendingDataQueues((VmPipeSessionImpl)this.getSession());
    }

    private void pushEvent(IoEvent e) {
        this.eventQueue.add(e);
        if (this.flushEnabled) {
            this.flushEvents();
        }
    }

    private void flushEvents() {
        IoEvent e;
        while ((e = this.eventQueue.poll()) != null) {
            this.fireEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(IoEvent e) {
        IoSession session = this.getSession();
        IoEventType type = e.getType();
        Object data = e.getParameter();
        if (type == IoEventType.MESSAGE_RECEIVED) {
            VmPipeSessionImpl s = (VmPipeSessionImpl)session;
            if (this.sessionOpened && s.getTrafficMask().isReadable() && s.getLock().tryLock()) {
                try {
                    if (!s.getTrafficMask().isReadable()) {
                        s.receivedMessageQueue.add(data);
                    }
                    super.fireMessageReceived(data);
                }
                finally {
                    s.getLock().unlock();
                }
            } else {
                s.receivedMessageQueue.add(data);
            }
        } else if (type == IoEventType.WRITE) {
            super.fireFilterWrite((WriteRequest)data);
        } else if (type == IoEventType.MESSAGE_SENT) {
            super.fireMessageSent((WriteRequest)data);
        } else if (type == IoEventType.EXCEPTION_CAUGHT) {
            super.fireExceptionCaught((Throwable)data);
        } else if (type == IoEventType.SESSION_IDLE) {
            super.fireSessionIdle((IdleStatus)data);
        } else if (type == IoEventType.SESSION_OPENED) {
            super.fireSessionOpened();
            this.sessionOpened = true;
        } else if (type == IoEventType.SESSION_CREATED) {
            super.fireSessionCreated();
        } else if (type == IoEventType.SESSION_CLOSED) {
            super.fireSessionClosed();
        } else if (type == IoEventType.CLOSE) {
            super.fireFilterClose();
        }
    }

    private static void flushPendingDataQueues(VmPipeSessionImpl s) {
        s.getProcessor().updateTrafficMask(s);
        s.getRemoteSession().getProcessor().updateTrafficMask(s);
    }

    @Override
    public void fireFilterClose() {
        this.pushEvent(new IoEvent(IoEventType.CLOSE, this.getSession(), null));
    }

    @Override
    public void fireFilterWrite(WriteRequest writeRequest) {
        this.pushEvent(new IoEvent(IoEventType.WRITE, this.getSession(), writeRequest));
    }

    @Override
    public void fireExceptionCaught(Throwable cause) {
        this.pushEvent(new IoEvent(IoEventType.EXCEPTION_CAUGHT, this.getSession(), cause));
    }

    @Override
    public void fireMessageSent(WriteRequest request) {
        this.pushEvent(new IoEvent(IoEventType.MESSAGE_SENT, this.getSession(), request));
    }

    @Override
    public void fireSessionClosed() {
        this.pushEvent(new IoEvent(IoEventType.SESSION_CLOSED, this.getSession(), null));
    }

    @Override
    public void fireSessionCreated() {
        this.pushEvent(new IoEvent(IoEventType.SESSION_CREATED, this.getSession(), null));
    }

    @Override
    public void fireSessionIdle(IdleStatus status) {
        this.pushEvent(new IoEvent(IoEventType.SESSION_IDLE, this.getSession(), status));
    }

    @Override
    public void fireSessionOpened() {
        this.pushEvent(new IoEvent(IoEventType.SESSION_OPENED, this.getSession(), null));
    }

    @Override
    public void fireMessageReceived(Object message) {
        this.pushEvent(new IoEvent(IoEventType.MESSAGE_RECEIVED, this.getSession(), message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VmPipeIoProcessor
    implements IoProcessor<VmPipeSessionImpl> {
        private VmPipeIoProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush(VmPipeSessionImpl session) {
            WriteRequestQueue queue = session.getWriteRequestQueue0();
            if (queue.isEmpty(session)) {
                return;
            }
            if (session.isConnected()) {
                if (session.getLock().tryLock()) {
                    try {
                        WriteRequest req;
                        while ((req = queue.poll(session)) != null) {
                            Object message;
                            Object messageCopy = message = req.getMessage();
                            if (message instanceof IoBuffer) {
                                IoBuffer rb = (IoBuffer)message;
                                rb.mark();
                                IoBuffer wb = IoBuffer.allocate(rb.remaining());
                                wb.put(rb);
                                wb.flip();
                                rb.reset();
                                messageCopy = wb;
                            }
                            session.getRemoteSession().getFilterChain().fireMessageReceived(messageCopy);
                            session.getFilterChain().fireMessageSent(req);
                        }
                    }
                    finally {
                        session.getLock().unlock();
                    }
                    VmPipeFilterChain.flushPendingDataQueues(session);
                }
            } else {
                WriteRequest req;
                ArrayList<WriteRequest> failedRequests = new ArrayList<WriteRequest>();
                while ((req = queue.poll(session)) != null) {
                    failedRequests.add(req);
                }
                if (!failedRequests.isEmpty()) {
                    WriteToClosedSessionException cause = new WriteToClosedSessionException(failedRequests);
                    for (WriteRequest r : failedRequests) {
                        r.getFuture().setException(cause);
                    }
                    session.getFilterChain().fireExceptionCaught(cause);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(VmPipeSessionImpl session) {
            try {
                session.getLock().lock();
                if (!session.getCloseFuture().isClosed()) {
                    session.getServiceListeners().fireSessionDestroyed(session);
                    session.getRemoteSession().close();
                }
            }
            finally {
                session.getLock().unlock();
            }
        }

        @Override
        public void add(VmPipeSessionImpl session) {
        }

        @Override
        public void updateTrafficMask(VmPipeSessionImpl session) {
            if (session.getTrafficMask().isReadable()) {
                ArrayList data = new ArrayList();
                session.receivedMessageQueue.drainTo(data);
                for (Object aData : data) {
                    VmPipeFilterChain.this.fireMessageReceived(aData);
                }
            }
            if (session.getTrafficMask().isWritable()) {
                this.flush(session);
            }
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public boolean isDisposing() {
            return false;
        }
    }
}

