/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.utils.SecuritySupport;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderManager {
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static final SAXParserFactory m_parserFactory;
    private static final boolean m_enableCaching;
    private ThreadLocal m_parser = new ThreadLocal();
    private ThreadLocal m_activeReader = new ThreadLocal();

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance() {
        return m_singletonManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLReader getXMLReader() throws SAXException {
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader context = ss.getContextClassLoader();
        try {
            if (m_enableCaching && this.m_activeReader.get() == null) {
                XMLReader reader;
                ss.setContextClassLoader(this.getClass().getClassLoader());
                SAXParser cached = (SAXParser)this.m_parser.get();
                if (cached != null) {
                    reader = cached.getXMLReader();
                } else {
                    SAXParser parser = m_parserFactory.newSAXParser();
                    this.m_parser.set(parser);
                    reader = parser.getXMLReader();
                }
                this.m_activeReader.set(reader);
                XMLReader xMLReader = reader;
                return xMLReader;
            }
            XMLReader cached = XMLReaderFactory.createXMLReader();
            return cached;
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (FactoryConfigurationError ex1) {
            throw new SAXException(ex1.toString());
        }
        catch (NoSuchMethodError ex2) {
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        finally {
            ss.setContextClassLoader(context);
        }
        return null;
    }

    public void releaseXMLReader(XMLReader reader) {
        if (m_enableCaching && reader == this.m_activeReader.get()) {
            this.m_activeReader.set(null);
            try {
                ((SAXParser)this.m_parser.get()).reset();
            }
            catch (Throwable th) {
                this.m_parser.set(null);
            }
        }
    }

    static {
        m_enableCaching = Boolean.getBoolean("xalan.enableParserCaching");
        if (m_enableCaching) {
            m_parserFactory = SAXParserFactory.newInstance();
            m_parserFactory.setNamespaceAware(true);
        } else {
            m_parserFactory = null;
        }
    }
}

