/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package aQute.junit.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter;

/**
 * An extension of the standard Ant PlainJUnitResultFormatter.
 * 
 * @author thomas.diesler@jboss.com
 * @since 01-Oct-2009
 */
public class PlainResultFormatter extends PlainJUnitResultFormatter {

	/**
	 * Creates an XMLResultFormatter with the given report specs. 
	 * 
	 * @param reportDir The directory to generate the test reports in
	 * @param testSuiteName The test suite name.
	 * @throws IOException if the test report file cannot be created
	 */
	public PlainResultFormatter(String reportDir, String testSuiteName) throws IOException {
		new File(reportDir).mkdirs();
		File outFile = new File(reportDir + "/" + testSuiteName + ".txt");
		setOutput(new FileOutputStream(outFile));
	}
}
