/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch2;

import com.google.common.primitives.Ints;
import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.elasticsearch2.DefaultElasticsearchComparisonStrategy;
import com.lordofthejars.nosqlunit.elasticsearch2.DefaultElasticsearchInsertionStrategy;
import com.lordofthejars.nosqlunit.elasticsearch2.ElasticsearchConnectionCallback;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;

public class ElasticsearchOperation
extends AbstractCustomizableDatabaseOperation<ElasticsearchConnectionCallback, Client> {
    private Client client;

    public ElasticsearchOperation(Client client) {
        this.client = client;
        this.setInsertionStrategy(new DefaultElasticsearchInsertionStrategy());
        this.setComparisonStrategy(new DefaultElasticsearchComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new ElasticsearchConnectionCallback(){

                @Override
                public Client nodeClient() {
                    return ElasticsearchOperation.this.client;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void deleteAll() {
        this.clearDocuments();
    }

    private void clearDocuments() {
        if (this.isAnyIndexPresent()) {
            SearchResponse searchResponse;
            SearchResponse countResponse = (SearchResponse)this.client.prepareSearch(new String[0]).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(0).execute().actionGet();
            int docCount = Ints.saturatedCast((long)countResponse.getHits().totalHits());
            SearchResponse scrollResponse = (SearchResponse)this.client.prepareSearch(new String[0]).setSearchType(SearchType.SCAN).setScroll(new TimeValue(1L, TimeUnit.MINUTES)).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(docCount).execute().actionGet();
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            do {
                searchResponse = (SearchResponse)this.client.prepareSearchScroll(scrollResponse.getScrollId()).setScroll(new TimeValue(1L, TimeUnit.MINUTES)).execute().actionGet();
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    bulkRequestBuilder.add(this.client.prepareDelete(hit.index(), hit.type(), hit.id()));
                }
            } while (searchResponse.getHits().getHits().length != 0);
            if (bulkRequestBuilder.numberOfActions() > 0) {
                BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.execute().actionGet();
            }
            this.refreshNode();
        }
    }

    private boolean isAnyIndexPresent() {
        CountResponse numberOfElements = (CountResponse)this.client.prepareCount(new String[0]).execute().actionGet();
        return numberOfElements.getCount() > 0L;
    }

    private void refreshNode() {
        this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    public boolean databaseIs(InputStream expectedData) {
        try {
            return this.executeComparison(new ElasticsearchConnectionCallback(){

                @Override
                public Client nodeClient() {
                    return ElasticsearchOperation.this.client;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public Client connectionManager() {
        return this.client;
    }
}

