/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch2;

import com.google.common.io.Files;
import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.elasticsearch2.EmbeddedElasticsearchInstancesFactory;
import java.io.File;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedElasticsearchLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedElasticsearchLifecycleManager.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 9300;
    private static final String HOME_PATH_PROPERTY = "path.home";
    private static final String DATA_PATH_PROPERTY = "path.data";
    public static final File EMBEDDED_ELASTICSEARCH_HOME_PATH = Files.createTempDir();
    public static final File EMBEDDED_ELASTICSEARCH_DATA_PATH = new File(EMBEDDED_ELASTICSEARCH_HOME_PATH, "data");
    private File homePath = EMBEDDED_ELASTICSEARCH_HOME_PATH;
    private File dataPath = EMBEDDED_ELASTICSEARCH_DATA_PATH;
    private NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().local(true);

    public String getHost() {
        return LOCALHOST + this.dataPath;
    }

    public int getPort() {
        return 9300;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting Embedded Elasticsearch instance.");
        this.nodeBuilder.getSettings().put(new Object[]{HOME_PATH_PROPERTY, this.homePath}).put(new Object[]{DATA_PATH_PROPERTY, this.dataPath});
        Node node = this.elasticsearchNode();
        EmbeddedElasticsearchInstancesFactory.getInstance().addEmbeddedInstance((Object)node, this.dataPath.getAbsolutePath());
        LOGGER.info("Started Embedded Elasticsearch instance.");
    }

    private Node elasticsearchNode() {
        return this.nodeBuilder.node();
    }

    public void doStop() {
        LOGGER.info("Stopping Embedded Elasticsearch instance.");
        Node node = (Node)EmbeddedElasticsearchInstancesFactory.getInstance().getEmbeddedByTargetPath(this.dataPath.getAbsolutePath());
        if (node != null) {
            node.close();
        }
        EmbeddedElasticsearchInstancesFactory.getInstance().removeEmbeddedInstance(this.dataPath.getAbsolutePath());
        LOGGER.info("Stopped Embedded Elasticsearch instance.");
    }

    public void setSettings(Settings settings) {
        this.nodeBuilder.settings(settings);
    }

    public void setClient(boolean client) {
        this.nodeBuilder.client(client);
    }

    public void setClusterName(String clusterName) {
        this.nodeBuilder.clusterName(clusterName);
    }

    public void setData(boolean data) {
        this.nodeBuilder.data(data);
    }

    public void setLocal(boolean local) {
        this.nodeBuilder.local(local);
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(File dataPath) {
        this.dataPath = dataPath;
    }

    public File getHomePath() {
        return this.homePath;
    }

    public void setHomePath(File homePath) {
        this.homePath = homePath;
    }
}

