/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch2;

import com.lordofthejars.nosqlunit.elasticsearch2.ElasticsearchConfiguration;
import java.net.InetSocketAddress;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class RemoteElasticsearchConfigurationBuilder {
    private ElasticsearchConfiguration elasticsearchConfiguration = new ElasticsearchConfiguration();

    private RemoteElasticsearchConfigurationBuilder() {
    }

    public static RemoteElasticsearchConfigurationBuilder remoteElasticsearch() {
        return new RemoteElasticsearchConfigurationBuilder();
    }

    public RemoteElasticsearchConfigurationBuilder port(int port) {
        this.elasticsearchConfiguration.setPort(port);
        return this;
    }

    public RemoteElasticsearchConfigurationBuilder host(String host) {
        this.elasticsearchConfiguration.setHost(host);
        return this;
    }

    public RemoteElasticsearchConfigurationBuilder settings(Settings settings) {
        this.elasticsearchConfiguration.setSettings(settings);
        return this;
    }

    public RemoteElasticsearchConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.elasticsearchConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public ElasticsearchConfiguration build() {
        InetSocketAddress address = new InetSocketAddress(this.elasticsearchConfiguration.getHost(), this.elasticsearchConfiguration.getPort());
        TransportClient client = this.getClient().addTransportAddress((TransportAddress)new InetSocketTransportAddress(address));
        this.elasticsearchConfiguration.setClient((Client)client);
        return this.elasticsearchConfiguration;
    }

    private TransportClient getClient() {
        if (this.elasticsearchConfiguration.getSettings() == null) {
            return TransportClient.builder().build();
        }
        return TransportClient.builder().settings(this.elasticsearchConfiguration.getSettings()).build();
    }
}

