/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch2.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;

public class DataReader {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String DOCUMENTS_ELEMENT = "documents";
    public static final String DOCUMENT_ELEMENT = "document";
    public static final String DATA_ELEMENT = "data";
    public static final String INDEX_ELEMENT = "index";
    public static final String INDEX_NAME_ELEMENT = "indexName";
    public static final String INDEX_TYPE_ELEMENT = "indexType";
    public static final String INDEX_ID_ELEMENT = "indexId";
    private Client client;

    public DataReader(Client client) {
        this.client = client;
    }

    public void read(InputStream data) {
        try {
            List<Map<String, Object>> documents = DataReader.getDocuments(data);
            this.insertDocuments(documents);
            this.refreshNode();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void refreshNode() {
        this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    private void insertDocuments(List<Map<String, Object>> documents) {
        for (Map<String, Object> document : documents) {
            Object object = document.get(DOCUMENT_ELEMENT);
            if (object instanceof List) {
                List properties = (List)object;
                this.insertDocument(properties);
                continue;
            }
            throw new IllegalArgumentException("Array of Indexes and Data are required.");
        }
    }

    private void insertDocument(List<Map<String, Object>> properties) {
        ArrayList<IndexRequestBuilder> indexes = new ArrayList<IndexRequestBuilder>();
        Map<String, Object> dataOfDocument = new HashMap<String, Object>();
        for (Map<String, Object> property : properties) {
            if (property.containsKey(INDEX_ELEMENT)) {
                indexes.add(this.createIndex(property.get(INDEX_ELEMENT)));
                continue;
            }
            if (!property.containsKey(DATA_ELEMENT)) continue;
            dataOfDocument = this.dataOfDocument(property.get(DATA_ELEMENT));
        }
        this.insertIndexes(indexes, dataOfDocument);
    }

    private void insertIndexes(List<IndexRequestBuilder> indexes, Map<String, Object> dataOfDocument) {
        for (IndexRequestBuilder indexRequestBuilder : indexes) {
            indexRequestBuilder.setSource(dataOfDocument).execute().actionGet();
        }
    }

    private Map<String, Object> dataOfDocument(Object object) {
        return (Map)object;
    }

    private IndexRequestBuilder createIndex(Object object) {
        Map indexInformation = (Map)object;
        IndexRequestBuilder prepareIndex = this.client.prepareIndex();
        if (indexInformation.containsKey(INDEX_NAME_ELEMENT)) {
            prepareIndex.setIndex((String)indexInformation.get(INDEX_NAME_ELEMENT));
        }
        if (indexInformation.containsKey(INDEX_TYPE_ELEMENT)) {
            prepareIndex.setType((String)indexInformation.get(INDEX_TYPE_ELEMENT));
        }
        if (indexInformation.containsKey(INDEX_ID_ELEMENT)) {
            prepareIndex.setId((String)indexInformation.get(INDEX_ID_ELEMENT));
        }
        return prepareIndex;
    }

    public static List<Map<String, Object>> getDocuments(InputStream data) throws IOException {
        Map rootNode = (Map)MAPPER.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object dataElements = rootNode.get(DOCUMENTS_ELEMENT);
        if (dataElements instanceof List) {
            return (List)dataElements;
        }
        throw new IllegalArgumentException("Array of documents are required.");
    }
}

