/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 2002, 2011 Oracle and/or its affiliates.  All rights reserved.
 *
 */

package com.sleepycat.je.rep;

import com.sleepycat.je.OperationFailureException;

/**
 * @hidden
 * Thrown by {@link com.sleepycat.je.rep.util.ReplicationGroupAdmin#transferMastership 
 * ReplicationGroupAdmin.transferMastership} if mastership transfer fails.
 */
public class MasterTransferFailureException extends OperationFailureException {

    private static final long serialVersionUID = 1;

    /** 
     * For internal use only.
     * @hidden 
     */
    public MasterTransferFailureException(String message) {
        super(null /*locker*/, false /*abortOnly*/, message, null /*cause*/);
    }

    /** 
     * For internal use only.
     * @hidden 
     */
    private MasterTransferFailureException
        (String message, MasterTransferFailureException cause) {
        super(message, cause);
    }

    /** 
     * For internal use only.
     * @hidden 
     */
    @Override
    public MasterTransferFailureException wrapSelf(String message) {
        return new MasterTransferFailureException(message, this);
    }
}
