/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;

public class RoleBindingBuilder
extends AbstractBuilder<RoleBinding, RoleBindingBuilder> {
    private String subjectKind;
    private String subjectName;
    private String subjectNamespace;
    private String roleRefKind = "Role";
    private String roleRefName;
    private String roleRefNamespace;

    public RoleBindingBuilder(String roleName) {
        this(null, roleName);
    }

    RoleBindingBuilder(ApplicationBuilder applicationBuilder, String roleName) {
        super(applicationBuilder, roleName);
    }

    public RoleBindingBuilder subjectKind(String subjectKind) {
        this.subjectKind = subjectKind;
        return this;
    }

    public RoleBindingBuilder subjectName(String subjectName) {
        this.subjectName = subjectName;
        return this;
    }

    public RoleBindingBuilder subjectNamespace(String subjectNamespace) {
        this.subjectNamespace = subjectNamespace;
        return this;
    }

    public RoleBindingBuilder roleRefKind(String roleRefKind) {
        this.roleRefKind = roleRefKind;
        return this;
    }

    public RoleBindingBuilder roleRefName(String roleRefName) {
        this.roleRefName = roleRefName;
        return this;
    }

    @Deprecated
    public RoleBindingBuilder roleRefNamespace(String roleRefNamespace) {
        this.roleRefNamespace = roleRefNamespace;
        return this;
    }

    @Override
    public RoleBinding build() {
        RoleBindingFluent.SubjectsNested subject = (RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder)((RoleBindingFluent.MetadataNested)new io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder().withNewMetadata().withName(this.getName())).endMetadata()).addNewSubject().withKind(this.subjectKind)).withName(this.subjectName);
        if (this.subjectNamespace != null && !this.subjectNamespace.isEmpty()) {
            subject.withNamespace(this.subjectNamespace);
        }
        RoleBindingFluent.RoleRefNested roleRef = (RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder)subject.endSubject()).withNewRoleRef().withKind(this.roleRefKind)).withName(this.roleRefName);
        return ((io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder)roleRef.endRoleRef()).build();
    }

    @Override
    protected RoleBindingBuilder getThis() {
        return this;
    }
}

