/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.builders.pod.ContainerBuilder;
import cz.xtf.builder.builders.pod.PersistentVolumeClaim;
import cz.xtf.builder.db.AbstractSQLDatabase;
import cz.xtf.builder.db.ProbeSettings;
import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.image.Image;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder;
import java.util.HashMap;
import java.util.Map;

public class MsSQL
extends AbstractSQLDatabase {
    private final String ANYUID_SERVICE_ACCOUNT = "anyuid-sa";
    private final long USER_ID = 0L;
    private static final String USERNAME = "sa";
    private static final String PASSWORD = "myMsSQLPassword123";
    private static final String DB_NAME = "master";
    private static final String SYMBOLIC_NAME = "MSSQL";
    private static final String DATA_DIR = "/var/lib/mssql/data";

    public MsSQL() {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR);
    }

    public MsSQL(boolean withLivenessProbe, boolean withReadinessProbe) {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR, withLivenessProbe, withReadinessProbe);
    }

    public MsSQL(PersistentVolumeClaim pvc) {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR, pvc);
    }

    public MsSQL(PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR, pvc, withLivenessProbe, withReadinessProbe);
    }

    public MsSQL(String username, String password, String dbName) {
        super(username, password, dbName, SYMBOLIC_NAME, DATA_DIR);
    }

    public MsSQL(String symbolicName, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(USERNAME, PASSWORD, DB_NAME, symbolicName, DATA_DIR, withLivenessProbe, withReadinessProbe);
    }

    @Override
    protected void configureContainer(ContainerBuilder containerBuilder) {
        super.configureContainer(containerBuilder);
        OpenShift master = OpenShifts.master();
        if (master.getServiceAccount("anyuid-sa") == null) {
            master.createServiceAccount(((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("anyuid-sa")).endMetadata()).build());
        }
        OpenShift admin = OpenShifts.admin();
        ((Resource)admin.securityContextConstraints().withName("anyuid")).edit(new Visitor[]{new Visitor<SecurityContextConstraintsBuilder>(){

            public void visit(SecurityContextConstraintsBuilder builder) {
                builder.addToUsers(new String[]{"system:serviceaccount:" + OpenShiftConfig.namespace() + ":" + "anyuid-sa"});
            }
        }});
        containerBuilder.pod().addServiceAccount("anyuid-sa");
        containerBuilder.pod().addRunAsUserSecurityContext(0L);
    }

    @Override
    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("MSSQL_SA_PASSWORD", this.getPassword());
        vars.put("ACCEPT_EULA", "Y");
        return vars;
    }

    @Override
    protected ProbeSettings getProbeSettings() {
        return ProbeSettings.builder().livenessInitialDelaySeconds(30).livenessTcpProbe(String.valueOf(this.getPort())).readinessInitialDelaySeconds(5).readinessProbeCommand("/opt/mssql-tools18/bin/sqlcmd -S localhost -d " + this.getDbName() + " -U " + this.getUsername() + " -P " + this.getPassword() + " -C -Q \"Select 1\"").startupInitialDelaySeconds(5).startupProbeCommand("/opt/mssql-tools18/bin/sqlcmd -S localhost -d " + this.getDbName() + " -U " + this.getUsername() + " -P " + this.getPassword() + " -C -Q \"Select 1\"").startupFailureThreshold(10).startupPeriodSeconds(10).build();
    }

    @Override
    protected String getJDBCConnectionStringPattern() {
        return "jdbc:sqlserver://%s:%s;databaseName=%s";
    }

    @Override
    public String getImageName() {
        return Image.resolve((String)"mssql").getUrl();
    }

    @Override
    public int getPort() {
        return 1433;
    }
}

