/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.core.image.Image;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.junit5.annotations.SkipFor;
import cz.xtf.junit5.annotations.SkipFors;
import cz.xtf.junit5.model.DockerImageMetadata;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class SkipForCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        SkipFor skipFor = AnnotationSupport.findAnnotation((Optional)context.getElement(), SkipFor.class).orElse(null);
        SkipFors skipFors = AnnotationSupport.findAnnotation((Optional)context.getElement(), SkipFors.class).orElse(null);
        if (skipFor != null) {
            return SkipForCondition.resolve(skipFor);
        }
        if (skipFors != null) {
            for (SkipFor sf : skipFors.value()) {
                ConditionEvaluationResult cer = SkipForCondition.resolve(sf);
                if (!cer.isDisabled()) continue;
                return cer;
            }
            return ConditionEvaluationResult.enabled((String)"Feature is expected to be available.");
        }
        return ConditionEvaluationResult.enabled((String)"SkipFor(s) annotation isn't present on target.");
    }

    public static ConditionEvaluationResult resolve(SkipFor skipFor) {
        Matcher matcher;
        if (skipFor.name().equals("") == skipFor.imageMetadataLabelName().equals("")) {
            throw new RuntimeException("Only one of 'name' and 'imageMetadataLabelName' can be presented in 'SkipFor' annotation.");
        }
        Image image = Image.resolve((String)skipFor.image());
        if (!skipFor.name().equals("")) {
            matcher = Pattern.compile(skipFor.name()).matcher(image.getRepo());
        } else {
            DockerImageMetadata metadata = DockerImageMetadata.get(OpenShifts.master(), image);
            matcher = Pattern.compile(skipFor.imageMetadataLabelName()).matcher(metadata.labels().get("name"));
        }
        if (matcher.matches()) {
            String reason = skipFor.reason().equals("") ? "" : " (" + skipFor.reason() + ")";
            return ConditionEvaluationResult.disabled((String)("Tested feature isn't expected to be available in '" + image.getRepo() + "' image." + reason));
        }
        return ConditionEvaluationResult.enabled((String)("Image '" + image.getRepo() + "' is expected to contain tested feature."));
    }
}

