/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions.helpers;

import cz.xtf.junit5.extensions.helpers.ResourcesTimestampHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.function.Predicate;

public class ResourcesFilterBuilder<E extends HasMetadata>
implements Cloneable {
    FilterMethod method;
    String[] resourceNames;
    ZonedDateTime excludeUntil;
    ZonedDateTime includeAlwaysAfter;
    ZonedDateTime includeAlwaysUntil;

    public Predicate<E> build() {
        switch (this.method) {
            case RESOURCE_NAMES: {
                return resource -> this.resourceNameMatches(this.getResourceName(resource), this.resourceNames);
            }
            case PREVIOUSLY_SEEN_RESOURCES: {
                return resource -> {
                    ZonedDateTime time = this.getResourceTime(resource);
                    return this.includeAlwaysAfter != null && this.includeAlwaysUntil != null && time.isAfter(this.includeAlwaysAfter) && !time.isAfter(this.includeAlwaysUntil) || this.excludeUntil != null && time.isAfter(this.excludeUntil);
                };
            }
        }
        return resource -> true;
    }

    String getResourceName(E item) {
        return item.getMetadata().getName();
    }

    ZonedDateTime getResourceTime(E item) {
        return ResourcesTimestampHelper.parseZonedDateTime(item.getMetadata().getCreationTimestamp());
    }

    public ZonedDateTime getExcludedUntil() {
        return this.excludeUntil;
    }

    public ResourcesFilterBuilder setExcludedUntil(ZonedDateTime until) {
        this.excludeUntil = until;
        return this;
    }

    public ResourcesFilterBuilder setIncludedAlwaysWindow(ZonedDateTime after, ZonedDateTime until) {
        this.includeAlwaysAfter = after;
        this.includeAlwaysUntil = until;
        return this;
    }

    public ZonedDateTime getIncludedAlwaysWindowAfter() {
        return this.includeAlwaysAfter;
    }

    public ZonedDateTime getIncludedAlwaysWindowUntil() {
        return this.includeAlwaysUntil;
    }

    public ResourcesFilterBuilder filterByResourceNames() {
        this.method = FilterMethod.RESOURCE_NAMES;
        return this;
    }

    public ResourcesFilterBuilder filterByLastSeenResources() {
        this.method = FilterMethod.PREVIOUSLY_SEEN_RESOURCES;
        return this;
    }

    public ResourcesFilterBuilder setResourceNames(String ... resourceNames) {
        this.resourceNames = Arrays.copyOf(resourceNames, resourceNames.length);
        return this;
    }

    public ResourcesFilterBuilder<E> clone() throws CloneNotSupportedException {
        return (ResourcesFilterBuilder)super.clone();
    }

    boolean resourceNameMatches(String resourceName, String[] resourceNamesLookup) {
        for (String resourceNameLookup : this.getRegexResourceNames(resourceNamesLookup)) {
            if (!resourceName.matches(resourceNameLookup)) continue;
            return true;
        }
        return false;
    }

    String[] getRegexResourceNames(String[] resourceNames) {
        String[] result = new String[resourceNames.length];
        for (int i = 0; i < resourceNames.length; ++i) {
            result[i] = resourceNames[i] + ".*";
        }
        return result;
    }

    static enum FilterMethod {
        RESOURCE_NAMES,
        PREVIOUSLY_SEEN_RESOURCES;

    }
}

