/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodLogRecorder
implements TestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PodLogRecorder.class);

    private String getTestDisplayName(TestIdentifier testIdentifier) {
        String className = ((String)testIdentifier.getParentId().get()).replaceAll(".*class:", "").replaceAll("].*", "");
        return String.format("%s#%s", className, testIdentifier.getDisplayName());
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Path podLogDir = Paths.get("log", "pods");
        if (testIdentifier.isTest() && TestExecutionResult.Status.FAILED.equals((Object)testExecutionResult.getStatus())) {
            Path testPodLogDir = podLogDir.resolve(this.getTestDisplayName(testIdentifier));
            OpenShift openShift = OpenShifts.master();
            for (Pod pod : openShift.getPods()) {
                try {
                    openShift.storePodLog(pod, testPodLogDir, pod.getMetadata().getName() + ".log");
                }
                catch (IOException e) {
                    log.warn("IOException storing pod logs", (Throwable)e);
                }
                catch (KubernetesClientException e) {
                    log.warn("KubernetesClientException getting pod logs", (Throwable)e);
                }
            }
        }
    }
}

