/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.junit5.annotations.KnownIssue;
import java.util.Optional;
import org.assertj.core.api.SoftAssertionError;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;
import org.opentest4j.TestAbortedException;

public class KnownIssueHandler
implements TestExecutionExceptionHandler {
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        String knownIssue = ((KnownIssue)AnnotationSupport.findAnnotation((Optional)context.getElement(), KnownIssue.class).orElseThrow(() -> throwable)).value();
        if (throwable instanceof SoftAssertionError && ((SoftAssertionError)throwable).getErrors().stream().allMatch(e -> e.contains(knownIssue))) {
            throw new TestAbortedException(knownIssue, throwable);
        }
        if (throwable instanceof AssertionError && !(throwable instanceof SoftAssertionError) && throwable.getMessage().contains(knownIssue)) {
            throw new TestAbortedException(knownIssue, throwable);
        }
        throw throwable;
    }
}

