/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class TestResultWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestResultWriter.class);
    private final Document xml;
    private final Path reportPath;
    private final AtomicInteger tests = new AtomicInteger(0);
    private final AtomicInteger errors = new AtomicInteger(0);
    private final AtomicInteger failures = new AtomicInteger(0);
    private final AtomicInteger ignored = new AtomicInteger(0);
    private final AtomicLong suiteStartTime = new AtomicLong(0L);
    private final AtomicReference<Element> testsuite = new AtomicReference();
    private final Map<String, Long> testTimes = new HashMap<String, Long>();

    public TestResultWriter() {
        Document xml = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            xml = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            log.error("Failed to create XML DOM!", (Throwable)ex);
        }
        Path reportPath = null;
        try {
            reportPath = Paths.get("log", "junit-report.xml").toAbsolutePath().normalize();
            Files.createFile(reportPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            log.error("Failed to create destination file!", (Throwable)ex);
        }
        this.xml = xml;
        this.reportPath = reportPath;
    }

    public void recordSuiteStart() {
        this.suiteStartTime.set(System.currentTimeMillis());
        Element testsuite = this.xml.createElement("testsuite");
        testsuite.setAttribute("name", "integration-suite");
        this.xml.appendChild(testsuite);
        this.testsuite.set(testsuite);
        this.writeXml();
    }

    public void recordTestStart(String testId) {
        this.testTimes.put(testId, System.currentTimeMillis());
    }

    public void recordSkippedTest(String testId, String className, String methodName, String reason) {
        this.ignored.incrementAndGet();
        Element testcase = this.createTestCase(testId, className, methodName);
        Element skipped = this.xml.createElement("skipped");
        skipped.setAttribute("message", reason);
        testcase.appendChild(skipped);
        this.testsuite.get().appendChild(testcase);
        this.writeXml();
    }

    public void recordSuccessfulTest(String testId, String className, String methodName) {
        if (this.testTimes.containsKey(testId)) {
            this.testsuite.get().appendChild(this.createTestCase(testId, className, methodName));
            this.writeXml();
        }
    }

    public void recordFailedTest(String testId, String className, String methodName, Throwable throwable) {
        Element element;
        Element testcase = this.createTestCase(testId, className, methodName);
        if (throwable instanceof AssertionError) {
            this.failures.incrementAndGet();
            element = this.xml.createElement("failure");
        } else {
            this.errors.incrementAndGet();
            element = this.xml.createElement("error");
        }
        testcase.appendChild(element);
        element.setAttribute("type", throwable.getClass().getName());
        element.setAttribute("message", throwable.getMessage());
        element.appendChild(this.xml.createCDATASection(this.stackTraceToString(throwable.getStackTrace())));
        this.testsuite.get().appendChild(testcase);
        this.writeXml();
    }

    private String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            sb.append(stackTraceElement.toString()).append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public void recordFinishedSuite() {
        this.writeXml();
    }

    private void writeXml() {
        Element testsuite = this.testsuite.get();
        testsuite.setAttribute("tests", Integer.toString(this.tests.get()));
        testsuite.setAttribute("errors", Integer.toString(this.errors.get()));
        testsuite.setAttribute("skipped", Integer.toString(this.ignored.get()));
        testsuite.setAttribute("failures", Integer.toString(this.failures.get()));
        testsuite.setAttribute("time", this.computeTestTime(this.suiteStartTime.get()));
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(this.reportPath, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                t.transform(new DOMSource(this.xml), new StreamResult(writer));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TransformerConfigurationException ex) {
            log.error("Misconfigured transformer", (Throwable)ex);
        }
        catch (TransformerException ex) {
            log.error("Unable to save XML file", (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn("Unable to open report file", (Throwable)ex);
        }
    }

    private String computeTestTime(Long startTime) {
        if (startTime == null) {
            return "0";
        }
        long amount = System.currentTimeMillis() - startTime;
        return String.format("%.3f", Float.valueOf((float)amount / 1000.0f));
    }

    private Element createTestCase(String testId, String className, String methodName) {
        this.tests.incrementAndGet();
        Element testcase = this.xml.createElement("testcase");
        testcase.setAttribute("name", methodName);
        testcase.setAttribute("classname", className);
        testcase.setAttribute("time", this.computeTestTime(this.testTimes.remove(testId)));
        return testcase;
    }
}

