/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.config;

import cz.xtf.core.config.XTFConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JUnitConfig {
    private static final String CLEAN_OPENSHIFT = "xtf.junit.clean_openshift";
    private static final String USED_IMAGES = "xtf.junit.used_images";
    private static final String CI_USERNAME = "xtf.junit.ci.username";
    private static final String CI_PASSWORD = "xtf.junit.ci.password";
    private static final String JENKINS_RERUN = "xtf.junit.jenkins.rerun";
    private static final String PREBUILDER_SYNCHRONIZED = "xtf.junit.prebuilder.synchronized";
    private static final String RECORD_DIR = "xtf.record.dir";
    private static final String RECORD_ALWAYS = "xtf.record.always";
    private static final String RECORD_BEFORE = "xtf.record.before";

    public static String recordDir() {
        return XTFConfig.get((String)RECORD_DIR);
    }

    public static boolean recordAlways() {
        return XTFConfig.get((String)RECORD_ALWAYS) != null && (XTFConfig.get((String)RECORD_ALWAYS).equals("") || XTFConfig.get((String)RECORD_ALWAYS).toLowerCase().equals("true"));
    }

    public static boolean recordBefore() {
        return XTFConfig.get((String)RECORD_BEFORE) != null && (XTFConfig.get((String)RECORD_BEFORE).equals("") || XTFConfig.get((String)RECORD_BEFORE).toLowerCase().equals("true"));
    }

    public static boolean cleanOpenShift() {
        return Boolean.valueOf(XTFConfig.get((String)CLEAN_OPENSHIFT, (String)"false"));
    }

    public static List<String> usedImages() {
        String images = XTFConfig.get((String)USED_IMAGES);
        if (images != null) {
            return Arrays.asList(images.split(","));
        }
        return Collections.emptyList();
    }

    public static String ciUsername() {
        return XTFConfig.get((String)CI_USERNAME);
    }

    public static String ciPassword() {
        return XTFConfig.get((String)CI_PASSWORD);
    }

    public static String jenkinsRerun() {
        return XTFConfig.get((String)JENKINS_RERUN);
    }

    public static boolean prebuilderSynchronized() {
        return Boolean.parseBoolean(XTFConfig.get((String)PREBUILDER_SYNCHRONIZED, (String)"false"));
    }
}

