/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.core.http.Https;
import cz.xtf.junit5.config.JUnitConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JenkinsRerunCondition
implements ExecutionCondition {
    private static final Logger log = LoggerFactory.getLogger(JenkinsRerunCondition.class);
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"not disabled");
    private static final ConditionEvaluationResult ENABLED_NOT_CLASS = ConditionEvaluationResult.enabled((String)"not a testclass");
    private static final int BUILDS_TO_TRY = 20;
    private Set<String> passedTests;
    private Set<String> failedTests;
    private boolean isEnabled = false;
    private boolean isInitialized = false;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        Optional optionalTestClass = extensionContext.getTestClass();
        if (!optionalTestClass.isPresent()) {
            return ENABLED_NOT_CLASS;
        }
        Class testClass = (Class)optionalTestClass.get();
        this.lazyInit();
        if (this.isEnabled && !this.failedTests.contains(testClass.getName()) && this.passedTests.contains(testClass.getName())) {
            log.debug("Excluding " + testClass.getName() + " containing only passed tests in previous test results");
            return ConditionEvaluationResult.disabled((String)("Disabling " + extensionContext.getDisplayName() + ", All tests from " + testClass.getName() + " passed in previous run"));
        }
        return ENABLED;
    }

    private String readContent(InputStream inputStream) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine).append("\n");
        }
        in.close();
        return content.toString().trim();
    }

    private String jenkinsHttpGet(String url, String username, String password) throws IOException {
        HttpsURLConnection connection = Https.getHttpsConnection((URL)new URL(url));
        if (StringUtils.isNotBlank((CharSequence)username)) {
            log.info("curl -k --user " + username + ":<blank> " + url);
            String basicAuth = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + basicAuth);
        } else {
            log.info("curl -k " + url);
        }
        connection.connect();
        String content = this.readContent(connection.getInputStream());
        if (connection.getResponseCode() != 200) {
            content = null;
        }
        connection.disconnect();
        return content;
    }

    private String jenkinsHttpGet(String url) throws IOException {
        return this.jenkinsHttpGet(url, JUnitConfig.ciUsername(), JUnitConfig.ciPassword());
    }

    private String findJobToRerun() {
        String jobToRerun = null;
        String currentBuildUrl = System.getenv("BUILD_URL");
        Pattern buildNoPattern = Pattern.compile("(.*/)([0-9]+)/$");
        Matcher m = buildNoPattern.matcher(currentBuildUrl);
        if (m.matches()) {
            String prefix = m.group(1);
            String buildNo = m.group(2);
            int build = Integer.parseInt(buildNo);
            int minBuild = build - 20;
            --build;
            while (build >= minBuild) {
                block11: {
                    String response;
                    try {
                        response = this.jenkinsHttpGet(prefix + "/" + build + "/api/xml");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block11;
                    }
                    if (response != null) {
                        try {
                            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                            DocumentBuilder db = dbf.newDocumentBuilder();
                            StringReader sr = new StringReader(response);
                            Document doc = db.parse((InputStream)new ReaderInputStream((Reader)sr, StandardCharsets.UTF_8));
                            NodeList nodeList = doc.getElementsByTagName("result");
                            int i = 0;
                            if (i < nodeList.getLength()) {
                                Element result = (Element)nodeList.item(i);
                                if (!"ABORTED".equals(result.getTextContent().trim())) break;
                                log.info("ignoring ABORTED build " + prefix + build);
                            }
                        }
                        catch (IOException | ParserConfigurationException | SAXException e) {
                            e.printStackTrace();
                        }
                    }
                }
                --build;
            }
            if (build >= minBuild) {
                log.info("using build " + prefix + build);
                jobToRerun = prefix + build;
            } else {
                log.error("Cannot configure JenkinsRerunFilter, didn't find any non-aborted run");
            }
        } else {
            log.error("Cannot configure JenkinsRerunFilter, failed to parse BUILD_URL {}", (Object)currentBuildUrl);
        }
        return jobToRerun;
    }

    private void lazyInit() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        String jobToRerun = JUnitConfig.jenkinsRerun();
        this.passedTests = new HashSet<String>();
        this.failedTests = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)jobToRerun) && ("true".equalsIgnoreCase(jobToRerun) || jobToRerun.startsWith("http"))) {
            if (!jobToRerun.startsWith("http") && (jobToRerun = this.findJobToRerun()) == null) {
                return;
            }
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                String responseXml = this.jenkinsHttpGet(jobToRerun + "/testReport/api/xml");
                StringReader sr = new StringReader(responseXml);
                Document doc = db.parse((InputStream)new ReaderInputStream((Reader)sr, "UTF-8"));
                NodeList nodeList = doc.getElementsByTagName("case");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element caseElement = (Element)nodeList.item(i);
                    String className = caseElement.getElementsByTagName("className").item(0).getTextContent();
                    String status = caseElement.getElementsByTagName("status").item(0).getTextContent();
                    String name = caseElement.getElementsByTagName("name").item(0).getTextContent();
                    log.trace("className {} name {} status {}", new Object[]{className, name, status});
                    if ("SKIPPED".equals(status) || "PASSED".equals(status) || "FIXED".equals(status)) {
                        this.passedTests.add(className);
                        continue;
                    }
                    if ("FAILED".equals(status) || "REGRESSION".equals(status)) {
                        this.failedTests.add(className);
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized test status " + status + " in test " + name + " of class " + className);
                }
                this.isEnabled = true;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }
    }
}

