/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.junit5.listeners.TestResultWriter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class TestResultReporter
implements TestExecutionListener {
    private final TestResultWriter testResultWriter = new TestResultWriter();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testResultWriter.recordSuiteStart();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testResultWriter.recordFinishedSuite();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.testResultWriter.recordTestStart(testIdentifier.getUniqueId());
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            String testId = testIdentifier.getUniqueId();
            String methodName = testIdentifier.getDisplayName();
            String className = testIdentifier.getParentId().orElse("null").replaceAll(".*class:", "").replaceAll("].*", "");
            this.testResultWriter.recordSkippedTest(testId, className, methodName, reason);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            String testId = testIdentifier.getUniqueId();
            String methodName = testIdentifier.getDisplayName();
            String className = testIdentifier.getParentId().orElse("null").replaceAll(".*class:", "").replaceAll("].*", "");
            switch (testExecutionResult.getStatus()) {
                case SUCCESSFUL: {
                    this.testResultWriter.recordSuccessfulTest(testId, className, methodName);
                    break;
                }
                case FAILED: {
                    this.testResultWriter.recordFailedTest(testId, className, methodName, (Throwable)testExecutionResult.getThrowable().orElseThrow(() -> new IllegalStateException("Failed test didn't throw anything!")));
                    break;
                }
                case ABORTED: {
                    this.testResultWriter.recordSkippedTest(testId, className, methodName, ((Throwable)testExecutionResult.getThrowable().orElse(new IllegalStateException())).getMessage());
                }
            }
        }
    }
}

