/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.core.bm.BuildManagers;
import cz.xtf.core.config.XTFConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.service.logs.streaming.AnnotationBasedServiceLogsConfigurations;
import cz.xtf.core.service.logs.streaming.ServiceLogs;
import cz.xtf.core.service.logs.streaming.ServiceLogsSettings;
import cz.xtf.core.service.logs.streaming.SystemPropertyBasedServiceLogsConfigurations;
import cz.xtf.core.service.logs.streaming.k8s.PodLogs;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLogsStreamingRunner
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(ServiceLogsStreamingRunner.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"cz", "xtf", "junit", "extensions", "ServiceLogsRunner"});
    private static final String SERVICE_LOGS_PROPERTY_BASED_CONFIGURATIONS = "SERVICE_LOGS:PROPERTY_BASED_CONFIGURATIONS";
    private static final String SERVICE_LOGS_ANNOTATION_BASED_CONFIGURATIONS = "SERVICE_LOGS:ANNOTATION_BASED_CONFIGURATIONS";
    private static final String SERVICE_LOGS_OUTPUT_STREAMS = "SERVICE_LOGS:OUTPUT_STREAMS";
    private static final String SERVICE_LOGS = "SERVICE_LOGS";
    private static final String SERVICE_LOGS_STREAMING_PROPERTY_CONFIG = "xtf.log.streaming.config";
    private static final String SERVICE_LOGS_STREAMING_PROPERTY_ENABLED = "xtf.log.streaming.enabled";

    public void beforeAll(ExtensionContext context) {
        if (this.getServiceLogsStreamingEnabledPropertyValue()) {
            this.enableServiceLogsStreamingForAllTests(context);
        }
        this.startServiceLogsStreaming(context);
    }

    public void afterAll(ExtensionContext context) {
        this.stopServiceLogsStreaming(context);
    }

    private void enableServiceLogsStreamingForAllTests(ExtensionContext extensionContext) {
        String key;
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        SystemPropertyBasedServiceLogsConfigurations systemPropertyBasedServiceLogsConfigurations = (SystemPropertyBasedServiceLogsConfigurations)store.get((Object)(key = SERVICE_LOGS_PROPERTY_BASED_CONFIGURATIONS), SystemPropertyBasedServiceLogsConfigurations.class);
        if (systemPropertyBasedServiceLogsConfigurations != null) {
            store.remove((Object)key);
        }
        store.put((Object)key, (Object)new SystemPropertyBasedServiceLogsConfigurations("target=.*"));
    }

    private SystemPropertyBasedServiceLogsConfigurations systemPropertyBasedServiceLogsConfigurations(ExtensionContext extensionContext) {
        String serviceLogsStreamingConfig;
        String key;
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        SystemPropertyBasedServiceLogsConfigurations systemPropertyBasedServiceLogsConfigurations = (SystemPropertyBasedServiceLogsConfigurations)store.get((Object)(key = SERVICE_LOGS_PROPERTY_BASED_CONFIGURATIONS), SystemPropertyBasedServiceLogsConfigurations.class);
        if (systemPropertyBasedServiceLogsConfigurations == null && (serviceLogsStreamingConfig = this.getServiceLogsStreamingConfigPropertyValue()) != null && !serviceLogsStreamingConfig.isEmpty()) {
            systemPropertyBasedServiceLogsConfigurations = new SystemPropertyBasedServiceLogsConfigurations(serviceLogsStreamingConfig);
            store.put((Object)key, (Object)systemPropertyBasedServiceLogsConfigurations);
        }
        return systemPropertyBasedServiceLogsConfigurations;
    }

    private AnnotationBasedServiceLogsConfigurations annotationBasedServiceLogsConfigurations(ExtensionContext extensionContext) {
        String key;
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        AnnotationBasedServiceLogsConfigurations annotationBasedServiceLogsConfigurations = (AnnotationBasedServiceLogsConfigurations)store.get((Object)(key = SERVICE_LOGS_ANNOTATION_BASED_CONFIGURATIONS), AnnotationBasedServiceLogsConfigurations.class);
        if (annotationBasedServiceLogsConfigurations == null) {
            annotationBasedServiceLogsConfigurations = new AnnotationBasedServiceLogsConfigurations();
            store.put((Object)key, (Object)annotationBasedServiceLogsConfigurations);
        }
        return annotationBasedServiceLogsConfigurations;
    }

    private Map<String, ServiceLogs> serviceLogs(ExtensionContext extensionContext) {
        String key;
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        HashMap serviceLogsMap = (HashMap)store.get((Object)(key = SERVICE_LOGS), Map.class);
        if (serviceLogsMap == null) {
            serviceLogsMap = new HashMap();
            store.put((Object)key, serviceLogsMap);
        }
        return serviceLogsMap;
    }

    private List<OutputStream> serviceLogsOutputStreams(ExtensionContext extensionContext) {
        String key;
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        ArrayList serviceLogsOutputStreams = (ArrayList)store.get((Object)(key = SERVICE_LOGS_OUTPUT_STREAMS), List.class);
        if (serviceLogsOutputStreams == null) {
            serviceLogsOutputStreams = new ArrayList();
            store.put((Object)key, serviceLogsOutputStreams);
        }
        return serviceLogsOutputStreams;
    }

    private String getServiceLogsStreamingConfigPropertyValue() {
        return XTFConfig.get((String)SERVICE_LOGS_STREAMING_PROPERTY_CONFIG, (String)"");
    }

    private boolean getServiceLogsStreamingEnabledPropertyValue() {
        return Boolean.parseBoolean(XTFConfig.get((String)SERVICE_LOGS_STREAMING_PROPERTY_ENABLED, (String)"false"));
    }

    private void startServiceLogsStreaming(ExtensionContext extensionContext) {
        ServiceLogsSettings currentClazzServiceLogsSettings = this.retrieveServiceLogsSettings(extensionContext);
        if (currentClazzServiceLogsSettings != null) {
            ServiceLogs serviceLogs = this.createServiceLogs(extensionContext, currentClazzServiceLogsSettings);
            this.serviceLogs(extensionContext).put(extensionContext.getRequiredTestClass().getName(), serviceLogs);
            serviceLogs.start();
        }
    }

    private ServiceLogsSettings retrieveServiceLogsSettings(ExtensionContext extensionContext) {
        ServiceLogsSettings currentClazzServiceLogsSettings;
        if (this.systemPropertyBasedServiceLogsConfigurations(extensionContext) != null && (currentClazzServiceLogsSettings = this.systemPropertyBasedServiceLogsConfigurations(extensionContext).forClass(extensionContext.getRequiredTestClass())) != null) {
            return currentClazzServiceLogsSettings;
        }
        return this.annotationBasedServiceLogsConfigurations(extensionContext).forClass(extensionContext.getRequiredTestClass());
    }

    private ServiceLogs createServiceLogs(ExtensionContext extensionContext, ServiceLogsSettings testClazzServiceLogsSettings) {
        log.debug("createServiceLogs");
        OpenShift openShift = OpenShifts.master();
        String masterNamespace = openShift.getNamespace();
        String buildsNamespace = BuildManagers.get().openShift().getNamespace();
        ArrayList<String> uniqueNamespaces = new ArrayList<String>();
        uniqueNamespaces.add(masterNamespace);
        if (!masterNamespace.equals(buildsNamespace)) {
            uniqueNamespaces.add(buildsNamespace);
        }
        PrintStream out = System.out;
        if (!"[unassigned]".equals(testClazzServiceLogsSettings.getOutputPath())) {
            try {
                File baseOutputPath = new File(testClazzServiceLogsSettings.getOutputPath());
                if (!baseOutputPath.exists() && !baseOutputPath.mkdirs()) {
                    throw new IllegalStateException("Cannot create SLS base output path: " + testClazzServiceLogsSettings.getOutputPath());
                }
                File outputFile = new File(testClazzServiceLogsSettings.getOutputPath(), extensionContext.getRequiredTestClass().getName());
                out = new PrintStream(new FileOutputStream(outputFile));
                this.serviceLogsOutputStreams(extensionContext).add(out);
            }
            catch (FileNotFoundException e) {
                log.warn("Could not create file stream {} because of the following error: {}. Redirecting to System.out", (Object)testClazzServiceLogsSettings.getOutputPath(), (Object)e.getMessage());
            }
        }
        PodLogs serviceLogs = new PodLogs.Builder().withClient((KubernetesClient)openShift).inNamespaces(uniqueNamespaces).outputTo(out).filter("[unassigned]".equals(testClazzServiceLogsSettings.getFilter()) ? null : testClazzServiceLogsSettings.getFilter()).build();
        return serviceLogs;
    }

    private void stopServiceLogsStreaming(ExtensionContext extensionContext) {
        for (ServiceLogs serviceLogs : this.serviceLogs(extensionContext).values()) {
            serviceLogs.stop();
        }
        for (OutputStream outputStream : this.serviceLogsOutputStreams(extensionContext)) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.warn("Couldn't close Print Stream due to IOException: {}", (Object)e.getMessage());
            }
        }
    }
}

