/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpConnection;
import dev.snowdrop.vertx.amqp.AmqpMessage;
import dev.snowdrop.vertx.amqp.AmqpReceiver;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpConnection;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SnowdropAmqpReceiver
implements AmqpReceiver {
    private final io.vertx.axle.amqp.AmqpReceiver delegate;
    private final MessageConverter messageConverter;

    SnowdropAmqpReceiver(io.vertx.axle.amqp.AmqpReceiver delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    public Mono<AmqpMessage> mono() {
        return Mono.from((Publisher)this.delegate.toPublisher()).map(this.messageConverter::toSnowdropMessage);
    }

    public Flux<AmqpMessage> flux() {
        return Flux.from((Publisher)this.delegate.toPublisher()).map(this.messageConverter::toSnowdropMessage);
    }

    @Override
    public String address() {
        return this.delegate.address();
    }

    @Override
    public AmqpConnection connection() {
        return new SnowdropAmqpConnection(this.delegate.connection(), this.messageConverter);
    }

    @Override
    public Mono<Void> close() {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.close());
    }

    public ReadStream vertxReadStream() {
        return this.delegate.getDelegate();
    }
}

