/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpMessage;
import java.io.Reader;
import java.io.StringReader;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;

class SnowdropAmqpMessage
implements AmqpMessage {
    private final io.vertx.amqp.AmqpMessage delegate;
    private final DataBufferFactory dataBufferFactory;

    SnowdropAmqpMessage(io.vertx.amqp.AmqpMessage delegate) {
        this.delegate = delegate;
        this.dataBufferFactory = new DefaultDataBufferFactory();
    }

    @Override
    public boolean isDurable() {
        return this.delegate.isDurable();
    }

    @Override
    public boolean isFirstAcquirer() {
        return this.delegate.isFirstAcquirer();
    }

    @Override
    public int priority() {
        return this.delegate.priority();
    }

    @Override
    public int deliveryCount() {
        return this.delegate.deliveryCount();
    }

    @Override
    public long ttl() {
        return this.delegate.ttl();
    }

    @Override
    public String id() {
        return this.delegate.id();
    }

    @Override
    public String address() {
        return this.delegate.address();
    }

    @Override
    public String replyTo() {
        return this.delegate.replyTo();
    }

    @Override
    public String correlationId() {
        return this.delegate.correlationId();
    }

    @Override
    public boolean isBodyNull() {
        return this.delegate.isBodyNull();
    }

    @Override
    public boolean bodyAsBoolean() {
        return this.delegate.bodyAsBoolean();
    }

    @Override
    public byte bodyAsByte() {
        return this.delegate.bodyAsByte();
    }

    @Override
    public short bodyAsShort() {
        return this.delegate.bodyAsShort();
    }

    @Override
    public int bodyAsInteger() {
        return this.delegate.bodyAsInteger();
    }

    @Override
    public long bodyAsLong() {
        return this.delegate.bodyAsLong();
    }

    @Override
    public float bodyAsFloat() {
        return this.delegate.bodyAsFloat();
    }

    @Override
    public double bodyAsDouble() {
        return this.delegate.bodyAsFloat();
    }

    @Override
    public char bodyAsChar() {
        return this.delegate.bodyAsChar();
    }

    @Override
    public Instant bodyAsTimestamp() {
        return this.delegate.bodyAsTimestamp();
    }

    @Override
    public UUID bodyAsUUID() {
        return this.delegate.bodyAsUUID();
    }

    @Override
    public DataBuffer bodyAsBinary() {
        return this.dataBufferFactory.wrap(this.delegate.bodyAsBinary().getBytes());
    }

    @Override
    public String bodyAsString() {
        return this.delegate.bodyAsString();
    }

    @Override
    public String bodyAsSymbol() {
        return this.delegate.bodyAsSymbol();
    }

    @Override
    public <T> List<T> bodyAsList() {
        return this.delegate.bodyAsList();
    }

    @Override
    public <K, V> Map<K, V> bodyAsMap() {
        return this.delegate.bodyAsMap();
    }

    @Override
    public JsonObject bodyAsJsonObject() {
        return Json.createParser((Reader)new StringReader(this.delegate.bodyAsJsonObject().toString())).getObject();
    }

    @Override
    public JsonArray bodyAsJsonArray() {
        return Json.createParser((Reader)new StringReader(this.delegate.bodyAsJsonArray().toString())).getArray();
    }

    @Override
    public String subject() {
        return this.delegate.subject();
    }

    @Override
    public String contentType() {
        return this.delegate.contentType();
    }

    @Override
    public String contentEncoding() {
        return this.delegate.contentEncoding();
    }

    @Override
    public long expiryTime() {
        return this.delegate.expiryTime();
    }

    @Override
    public long creationTime() {
        return this.delegate.creationTime();
    }

    @Override
    public String groupId() {
        return this.delegate.groupId();
    }

    @Override
    public String replyToGroupId() {
        return this.delegate.replyToGroupId();
    }

    @Override
    public long groupSequence() {
        return this.delegate.groupSequence();
    }

    @Override
    public io.vertx.amqp.AmqpMessage toVertxAmqpMessage() {
        return this.delegate;
    }
}

