/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLSession;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class SslInfoImpl
implements SslInfo {
    private final SSLSession session;

    SslInfoImpl(SSLSession session) {
        Assert.notNull((Object)session, (String)"SSLSession is required");
        this.session = session;
    }

    @Nullable
    public String getSessionId() {
        byte[] bytes = this.session.getId();
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String digit = Integer.toHexString(b);
            if (digit.length() < 2) {
                sb.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            sb.append(digit);
        }
        return sb.toString();
    }

    @Nullable
    public X509Certificate[] getPeerCertificates() {
        Certificate[] certificates;
        try {
            certificates = this.session.getPeerCertificates();
        }
        catch (Throwable ex) {
            return null;
        }
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certificates.length);
        for (Certificate certificate : certificates) {
            if (!(certificate instanceof X509Certificate)) continue;
            result.add((X509Certificate)certificate);
        }
        return !result.isEmpty() ? result.toArray(new X509Certificate[0]) : null;
    }
}

