/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.internal.dialogs;

import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.resource.BirtWTPMessages;
import org.eclipse.birt.integration.wtp.ui.internal.util.DataUtil;
import org.eclipse.birt.integration.wtp.ui.internal.util.UIUtil;
import org.eclipse.birt.integration.wtp.ui.internal.util.WebArtifactUtil;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ContextParamBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BirtConfigurationDialog
extends Dialog
implements IBirtWizardConstants {
    protected Map properties;
    protected Text txtResourceFolder;
    protected Text txtWorkingFolder;
    protected Text txtDocumentFolder;
    protected Button btAccessOnly;
    protected Text txtImageFolder;
    protected Text txtScriptlibFolder;
    protected Text txtLogFolder;
    protected Button btLogLevel;
    protected Button btOverwrite;
    protected Text txtMaxRows;
    protected Text txtMaxRowLevels;
    protected Text txtMaxColumnLevels;
    protected Text txtCubeMemorySize;
    protected Combo cbLogLevel;
    protected Combo cbPrintServer;
    protected Button btClear;
    private boolean isClear;

    public BirtConfigurationDialog(Shell parentShell, Map properties) {
        super(parentShell);
        this.properties = properties;
    }

    protected BirtConfigurationDialog(IShellProvider parentShell, Map properties) {
        super(parentShell);
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(BirtWTPMessages.BIRTConfigurationDialog_title);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group paths = new Group(composite, 0);
        paths.setLayout((Layout)new GridLayout());
        paths.setLayoutData((Object)new GridData(768));
        paths.setText(BirtWTPMessages.BIRTConfiguration_group_paths);
        paths.setEnabled(true);
        UIUtil uit = new UIUtil(this.properties);
        this.txtResourceFolder = uit.createResourceFolderGroup((Composite)paths);
        ContextParamBean param = (ContextParamBean)this.properties.get("BIRT_RESOURCE_PATH");
        String resFolder = null;
        if (param != null) {
            resFolder = param.getValue();
        }
        if (resFolder != null && resFolder.trim().length() > 0) {
            this.txtResourceFolder.setText(resFolder.trim());
        }
        this.txtWorkingFolder = uit.createWorkingFolderGroup((Composite)paths);
        this.txtDocumentFolder = uit.createDocumentFolderGroup((Composite)paths);
        this.txtImageFolder = uit.createImageFolderGroup((Composite)paths);
        this.txtScriptlibFolder = uit.createScriptLibFolderGroup((Composite)paths);
        this.txtLogFolder = uit.createLogFolderGroup((Composite)paths);
        Group others = new Group(composite, 0);
        others.setLayout((Layout)new GridLayout());
        others.setLayoutData((Object)new GridData(768));
        others.setText(BirtWTPMessages.BIRTConfiguration_group_others);
        others.setEnabled(true);
        this.btAccessOnly = uit.createAccessOnlyGroup((Composite)others);
        this.btOverwrite = uit.createOverwriteGroup((Composite)others);
        this.cbLogLevel = uit.createLogLevelGroup((Composite)others);
        this.cbPrintServer = uit.createPrintServerGroup((Composite)others);
        this.txtMaxRows = uit.createMaxRowsGroup((Composite)others);
        this.txtMaxRowLevels = uit.createMaxRowLevelsGroup((Composite)others);
        this.txtMaxColumnLevels = uit.createMaxColumnLevelsGroup((Composite)others);
        this.txtCubeMemorySize = uit.createCubeMemorySizeGroup((Composite)others);
        this.btClear = uit.createImportClearSetting(composite);
        this.isClear = this.btClear.getSelection();
        this.initializeProperties();
        return composite;
    }

    protected void initializeProperties() {
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_RESOURCE_PATH", this.txtResourceFolder.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_WORKING_FOLDER", this.txtWorkingFolder.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_DOCUMENT_FOLDER", this.txtDocumentFolder.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "WORKING_FOLDER_ACCESS_ONLY", new String("" + this.btAccessOnly.getSelection()));
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_IMAGE_DIR", this.txtImageFolder.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_SCRIPTLIB_DIR", this.txtScriptlibFolder.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_LOG_DIR", this.txtLogFolder.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_OVERWRITE_DOCUMENT", new String("" + this.btOverwrite.getSelection()));
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_MAX_ROWS", DataUtil.getNumberSetting(this.txtMaxRows.getText()));
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_MAX_CUBE_ROWLEVELS", DataUtil.getNumberSetting(this.txtMaxRowLevels.getText()));
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_MAX_CUBE_COLUMNLEVELS", DataUtil.getNumberSetting(this.txtMaxColumnLevels.getText()));
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_CUBE_MEMORY_SIZE", DataUtil.getNumberSetting(this.txtCubeMemorySize.getText()));
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_LOG_LEVEL", this.cbLogLevel.getText());
        WebArtifactUtil.setContextParamValue(this.properties, "BIRT_VIEWER_PRINT_SERVERSIDE", this.cbPrintServer.getText());
    }

    protected void okPressed() {
        this.isClear = this.btClear.getSelection();
        super.okPressed();
    }

    public boolean isClear() {
        return this.isClear;
    }
}

