/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.result;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.result.ResultSupportRunnable;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SimpleSQLResultRunnable
extends ResultSupportRunnable {
    protected static final int SQL_SHORT_DESC_LENGTH = 40;
    protected Connection _connection;
    protected String _sql;
    protected boolean _closeCon;
    protected int _connid;
    protected IConnectionTracker _tracker;
    protected boolean _promptVar = false;
    protected ILaunchConfiguration _configuration;

    public SimpleSQLResultRunnable(Connection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration) {
        super(SQLUtil.describeSQL((String)sql, (int)40), parentMonitor, databaseIdentifier);
        this._connection = con;
        this._sql = sql;
        this._closeCon = closeCon;
        this._tracker = tracker;
        this._configuration = configuration;
        this._connid = SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)this._connection);
    }

    protected Connection getConnection() {
        return this._connection;
    }

    protected void setConnection(Connection conn) {
        this._connection = conn;
    }

    protected OperationCommand createDefaultOperationCommand() {
        return new OperationCommand(this.getActionType(), this._sql, this.getConsumerName(), this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    protected boolean runStatement(Statement stmt) throws SQLException {
        return stmt.execute(this._sql);
    }

    protected void handleEnd(Connection connection, Statement stmt) {
        try {
            if (this._tracker != null) {
                this._tracker.connectionAboutToBeClosed();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null && !this.isTerminated() && !this.isCanceled() && this._closeCon) {
                SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
                ConnectionService conService = f.getConnectionService();
                conService.closeConnection(connection, this._connid, this._databaseIdentifier);
            }
        }
        catch (Exception exception) {}
        if (this._closeCon && this._tracker != null) {
            this._tracker.connectionClosed();
        }
    }

    public ILaunchConfiguration getConfiguration() {
        return this._configuration;
    }
}

