/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XSDFileSchemaTreePopulator;

public class SchemaPopulationUtil {
    private static final String XSD_EXTENSION = ".XSD";

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlFileName, String xmlEncoding, int numberOfElementsAccessiable) throws OdaException, MalformedURLException, URISyntaxException {
        if (xsdFileName != null && xsdFileName.toUpperCase().endsWith(XSD_EXTENSION)) {
            if (xmlFileName != null && xmlFileName.trim().length() > 0) {
                return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, xmlFileName, xmlEncoding);
            }
            return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, xmlEncoding);
        }
        return new XMLFileSchemaTreePopulator(numberOfElementsAccessiable).getSchemaTree(xmlFileName, xmlEncoding);
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlFileName, int numberOfElementsAccessiable) throws OdaException, MalformedURLException, URISyntaxException {
        return SchemaPopulationUtil.getSchemaTree(xsdFileName, xmlFileName, null, numberOfElementsAccessiable);
    }

    public static Map getPrefixMapping(String xmlFileName, String xmlEncoding) throws OdaException {
        return new XMLFileSchemaTreePopulator(1).getPrefixMapping(xmlFileName, xmlEncoding);
    }
}

