/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator;
import org.w3c.dom.ls.LSInput;

final class XSDFileSchemaTreePopulator {
    private static final String ROOT_LITERAL = "ROOT";

    XSDFileSchemaTreePopulator() {
    }

    public static ATreeNode getSchemaTree(String schemafileName, String xmlFileName, String xmlEncoding) throws OdaException, MalformedURLException, URISyntaxException {
        ATreeNode xmlRoot = new XMLFileSchemaTreePopulator(2).getSchemaTree(xmlFileName, xmlEncoding);
        XSNamedMap map = XSDFileSchemaTreePopulator.loadSchema(schemafileName, xmlEncoding);
        ATreeNode xsdRoot = new ATreeNode();
        xsdRoot.setValue(ROOT_LITERAL);
        int i = 0;
        while (i < map.getLength()) {
            XSElementDecl element = (XSElementDecl)map.item(i);
            ATreeNode node = new ATreeNode(element);
            xsdRoot.addChild(node);
            if (xmlRoot != null && node.getValue().equals(((ATreeNode)xmlRoot.getChildren()[0]).getValue())) {
                xsdRoot = new ATreeNode();
                xsdRoot.setValue(ROOT_LITERAL);
                xsdRoot.addChild(node);
                break;
            }
            ++i;
        }
        return xsdRoot;
    }

    private static XSNamedMap loadSchema(String schemafileName, String xmlEncoding) throws MalformedURLException, URISyntaxException, OdaException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        URI uri = null;
        File f = new File(schemafileName);
        if (f.exists()) {
            uri = f.toURI();
        } else {
            URL url = new URL(schemafileName);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        if (uri == null) {
            uri = new URI(schemafileName);
        }
        XMLSchemaLoader xsLoader = new XMLSchemaLoader();
        DOMInputImpl input = new DOMInputImpl();
        try {
            input.setCharacterStream(new BufferedReader(new InputStreamReader(uri.toURL().openStream())));
        }
        catch (IOException iOException) {
            throw new OdaException(Messages.getString("ui.invalidXSDFile"));
        }
        input.setEncoding(xmlEncoding);
        XSModel xsModel = xsLoader.load((LSInput)input);
        if (xsModel == null) {
            throw new OdaException(Messages.getString("ui.invalidXSDFile"));
        }
        return xsModel.getComponents((short)2);
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlEncoding) throws OdaException, MalformedURLException, URISyntaxException {
        XSNamedMap map = XSDFileSchemaTreePopulator.loadSchema(xsdFileName, xmlEncoding);
        ATreeNode root = new ATreeNode();
        root.setValue(ROOT_LITERAL);
        int i = 0;
        while (i < map.getLength()) {
            XSElementDecl element = (XSElementDecl)map.item(i);
            ATreeNode node = new ATreeNode(element);
            node.setValue(element.getName());
            node.setType(1);
            node.setDataType(element.getName());
            root.addChild(node);
            ++i;
        }
        return root;
    }

    public static ATreeNode getSchemaTree(String xsdFileName) throws OdaException, MalformedURLException, URISyntaxException {
        return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, null);
    }
}

