/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataTypeUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColumnMappingDialog
extends TrayDialog {
    private static final String EMPTY_STRING = "";
    private String title;
    private Combo typeCombo;
    private String columnName;
    private String xpath;
    private String type;
    private Text columnNameText;
    private Button absolutePathButton;
    private Button anyLocationButton;
    private Button customButton;
    private Label absoluteLabel;
    private Label anyLocationLabel;
    private Combo xmlPathCombo;
    private Text xmlPathText;
    private List xpathList;
    private boolean isMappingMode;
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};

    public ColumnMappingDialog(Shell parent, String title, String selectedItem, String xpath, int dataType, boolean isMappingMode) {
        super(parent);
        this.initializeDialogInfos(title, selectedItem, xpath, dataType, isMappingMode);
    }

    private void initializeDialogInfos(String title, String selectedItem, String xpath, int dataType, boolean isMappingMode) {
        this.title = title;
        this.columnName = selectedItem == null ? EMPTY_STRING : selectedItem;
        this.xpath = xpath == null ? EMPTY_STRING : xpath;
        this.type = DataTypeUtil.getDataTypeDisplayName(dataType);
        this.isMappingMode = isMappingMode;
        this.xpathList = isMappingMode ? XPathPopulationUtil.getPathList((String)xpath) : null;
        Arrays.sort(dataTypeDisplayNames);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setupTopComposite(composite);
        if (this.isMappingMode) {
            this.setupButtonComposite(composite);
        } else {
            this.setupCustomExprArea(composite);
        }
        return composite;
    }

    private void setupTopComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        layout.verticalSpacing = 8;
        topComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        topComposite.setLayoutData((Object)gridData);
        GridData comboData = new GridData();
        comboData.widthHint = 300;
        GridData labelData = new GridData();
        Label label = new Label(topComposite, 0);
        label.setText(Messages.getString("ColumnMappingDialog.info.columnName"));
        label.setLayoutData((Object)labelData);
        labelData.widthHint = label.getSize().x > 100 ? label.getSize().x : 100;
        this.columnNameText = new Text(topComposite, 2048);
        this.columnNameText.setLayoutData((Object)comboData);
        this.columnNameText.setText(this.columnName);
        this.columnNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.columnName = ColumnMappingDialog.this.columnNameText.getText();
                ColumnMappingDialog.this.updateOKbuttonState();
            }
        });
        labelData = new GridData();
        Label label2 = new Label(topComposite, 0);
        label2.setText(Messages.getString("ColumnMappingDialog.info.dataType"));
        label2.setLayoutData((Object)labelData);
        labelData.widthHint = label2.getSize().x > 100 ? label2.getSize().x : 100;
        this.typeCombo = new Combo(topComposite, 12);
        int typeIndex = -1;
        int stringIndex = -1;
        int i = 0;
        while (i < dataTypeDisplayNames.length) {
            this.typeCombo.add(dataTypeDisplayNames[i]);
            if (dataTypeDisplayNames[i].equals(this.type)) {
                typeIndex = i;
            } else if (dataTypeDisplayNames[i].equals(Messages.getString("datatypes.string"))) {
                stringIndex = i;
            }
            ++i;
        }
        if (typeIndex == -1) {
            typeIndex = stringIndex;
        }
        this.columnNameText.setLayoutData((Object)comboData);
        this.typeCombo.setLayoutData((Object)comboData);
        this.typeCombo.select(typeIndex);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ColumnMappingDialog.this.typeCombo.getSelectionIndex();
                ColumnMappingDialog.this.columnName = ColumnMappingDialog.this.typeCombo.getItem(index);
            }
        });
        XMLRelationInfoUtil.setSystemHelp((Control)topComposite, "org.eclipse.datatools.oda.cshelp.Dialog_ColumnMapping_ID");
    }

    private void setupCustomExprArea(Composite parent) {
        Composite customComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        layout.verticalSpacing = 8;
        customComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        customComposite.setLayoutData((Object)gridData);
        GridData labelData = new GridData();
        labelData.horizontalAlignment = 10;
        Label customLabel = new Label(customComposite, 64);
        customLabel.setText(Messages.getString("ColumnMappingDialog.info.xPath"));
        customLabel.setLayoutData((Object)labelData);
        GridData textData = new GridData();
        textData.widthHint = 300;
        textData.horizontalAlignment = 10;
        this.xmlPathText = new Text(customComposite, 2048);
        this.xmlPathText.setText(this.xpath);
        this.xmlPathText.setLayoutData((Object)textData);
        this.xmlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xmlPathText.getText();
            }
        });
    }

    ColumnMappingElement getColumnMapping() {
        ColumnMappingElement columnEle = new ColumnMappingElement();
        columnEle.setColumnName(this.columnName);
        columnEle.setXPath(this.xpath);
        columnEle.setType(this.type);
        return columnEle;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.columnName = this.columnNameText.getText();
            this.type = this.typeCombo.getItem(this.typeCombo.getSelectionIndex());
        }
        super.buttonPressed(buttonId);
    }

    private void setupButtonComposite(Composite composite) {
        Composite exprBtnGroup = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        exprBtnGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 20;
        layout.verticalSpacing = 8;
        exprBtnGroup.setLayout((Layout)layout);
        GridData buttonGd = new GridData(34);
        GridData labelData = new GridData(768);
        this.absolutePathButton = new Button(exprBtnGroup, 16);
        this.absolutePathButton.setLayoutData((Object)buttonGd);
        this.absolutePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnMappingDialog.this.absolutePathButton.getSelection()) {
                    ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xpathList.get(0).toString();
                    ColumnMappingDialog.this.absolutePathButton.setSelection(true);
                    ColumnMappingDialog.this.anyLocationButton.setSelection(false);
                    ColumnMappingDialog.this.customButton.setSelection(false);
                    ColumnMappingDialog.this.xmlPathCombo.setVisible(false);
                }
            }
        });
        this.absoluteLabel = new Label(exprBtnGroup, 64);
        this.absoluteLabel.setLayoutData((Object)labelData);
        this.absoluteLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xpathList.get(0).toString();
                ColumnMappingDialog.this.absolutePathButton.setSelection(true);
                ColumnMappingDialog.this.anyLocationButton.setSelection(false);
                ColumnMappingDialog.this.customButton.setSelection(false);
                ColumnMappingDialog.this.xmlPathCombo.setVisible(false);
            }
        });
        this.anyLocationButton = new Button(exprBtnGroup, 16);
        this.anyLocationButton.setLayoutData((Object)buttonGd);
        this.anyLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnMappingDialog.this.anyLocationButton.getSelection()) {
                    ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xpathList.get(1).toString();
                    ColumnMappingDialog.this.anyLocationButton.setSelection(true);
                    ColumnMappingDialog.this.absolutePathButton.setSelection(false);
                    ColumnMappingDialog.this.customButton.setSelection(false);
                    ColumnMappingDialog.this.xmlPathCombo.setVisible(false);
                }
            }
        });
        this.anyLocationLabel = new Label(exprBtnGroup, 64);
        this.anyLocationLabel.setLayoutData((Object)labelData);
        this.anyLocationLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xpathList.get(1).toString();
                ColumnMappingDialog.this.anyLocationButton.setSelection(true);
                ColumnMappingDialog.this.absolutePathButton.setSelection(false);
                ColumnMappingDialog.this.customButton.setSelection(false);
                ColumnMappingDialog.this.xmlPathCombo.setVisible(false);
            }
        });
        this.setLabelValues(exprBtnGroup);
        GridData customData = new GridData(768);
        customData.horizontalSpan = 2;
        customData.widthHint = 400;
        this.customButton = new Button(exprBtnGroup, 16);
        this.customButton.setLayoutData((Object)customData);
        this.customButton.setText(Messages.getString("xPathChoosePage.messages.elementSelection.item.custom"));
        this.customButton.setSelection(true);
        this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnMappingDialog.this.customButton.getSelection()) {
                    ColumnMappingDialog.this.xmlPathCombo.setVisible(true);
                }
            }
        });
        GridData blankButtonGd = new GridData();
        blankButtonGd.verticalAlignment = 1;
        blankButtonGd.horizontalSpan = 1;
        GridData blankButtonData = new GridData();
        blankButtonData.horizontalSpan = 1;
        Button blankButton = new Button(exprBtnGroup, 0);
        blankButton.setData((Object)blankButtonData);
        blankButton.setVisible(false);
        GridData txtGridData = new GridData();
        txtGridData.horizontalSpan = 1;
        txtGridData.widthHint = 260;
        this.xmlPathCombo = new Combo(exprBtnGroup, 4);
        this.xmlPathCombo.setLayoutData((Object)txtGridData);
        this.xmlPathCombo.setVisible(true);
        this.setupCustomXMLPathField();
        this.xmlPathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.xmlPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xmlPathCombo.getText();
            }
        });
    }

    private void setLabelValues(Composite composite) {
        if (this.xpathList == null) {
            this.absoluteLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.absolutePath"));
            this.anyLocationLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.anyLocation"));
            this.setButtonsEnabled(false);
            return;
        }
        if (this.xpathList.size() >= 2) {
            this.absoluteLabel.setText(Messages.getFormattedString("xPathChoosePage.messages.elementSelection.item.absolutePath", new String[]{this.columnName, (String)this.xpathList.get(0)}));
            this.anyLocationLabel.setText(Messages.getFormattedString("xPathChoosePage.messages.elementSelection.item.anyLocation", new String[]{this.columnName, (String)this.xpathList.get(1)}));
            this.setButtonsEnabled(true);
        } else {
            this.absoluteLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.absolutePath"));
            this.anyLocationLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.anyLocation"));
            this.setButtonsEnabled(false);
        }
        composite.layout();
    }

    private void setButtonsEnabled(boolean enabled) {
        this.absolutePathButton.setEnabled(enabled);
        this.absoluteLabel.setEnabled(enabled);
        this.anyLocationButton.setEnabled(enabled);
        this.anyLocationLabel.setEnabled(enabled);
    }

    private void setupCustomXMLPathField() {
        if (this.xpathList == null || this.xpathList.size() < 2) {
            this.xmlPathCombo.setText(EMPTY_STRING);
            this.setButtonsEnabled(false);
            return;
        }
        this.xmlPathCombo.setText(this.xpathList.get(0).toString());
        this.xmlPathCombo.add(this.xpathList.get(0).toString());
        this.xmlPathCombo.add(this.xpathList.get(1).toString());
        this.xpath = this.xmlPathCombo.getText();
    }

    private void updateOKbuttonState() {
        if (this.columnName == null || this.columnName.trim().length() == 0) {
            this.enableOKButton(false);
        } else {
            this.enableOKButton(true);
        }
    }

    private void enableOKButton(boolean enabled) {
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(enabled);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateOKbuttonState();
        return control;
    }
}

