/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeDataUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreePopulationUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class XMLTreeViewer {
    private Button btnSingleAdd;
    private Button btnMultiAdd;
    private TreeViewer treeViewer;
    private Composite btnComposite;
    private String xPathExpression;
    private static String ATTRIBUTE_MARK = "@";
    private static final String ROOT = "ROOT";
    private static final String EMPTY_STRING = "";
    private static String PATH_SEPERATOR = "/";

    XMLTreeViewer(Composite parent, boolean supportMultiSelection) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(47, -5);
        data.bottom = new FormAttachment(100, -5);
        Group treeGroup = new Group(parent, 0);
        treeGroup.setLayout((Layout)new FillLayout());
        treeGroup.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer((Composite)treeGroup, 2818);
        data = new FormData();
        data.left = new FormAttachment((Control)treeGroup, 5);
        data.bottom = new FormAttachment(50);
        data.width = 20;
        data = new FormData();
        data.left = new FormAttachment((Control)treeGroup, 5);
        data.bottom = new FormAttachment(50);
        this.btnComposite = new Composite(parent, 0);
        this.btnComposite.setLayoutData((Object)data);
        FillLayout btnLayout = new FillLayout(512);
        btnLayout.spacing = 5;
        this.btnComposite.setLayout((Layout)btnLayout);
        this.btnSingleAdd = new Button(this.btnComposite, 0);
        this.btnSingleAdd.setText(">");
        this.btnSingleAdd.setEnabled(false);
        this.btnSingleAdd.setToolTipText("xPathChoosePage.messages.btnAdd.tooltip");
        this.btnMultiAdd = new Button(this.btnComposite, 0);
        this.btnMultiAdd.setText(">>");
        this.btnMultiAdd.setToolTipText(Messages.getString("ColumnMappingPage.AddAllButton.tooltip"));
        this.btnMultiAdd.setEnabled(true);
        this.btnMultiAdd.setToolTipText("xPathChoosePage.messages.btnAdd.tooltip");
        if (!supportMultiSelection) {
            this.btnMultiAdd.setVisible(false);
        }
        treeGroup.setText(Messages.getString("xPathChoosePage.messages.xmlStructure"));
    }

    void populateTree(ATreeNode treeNode, String xPathExpression, boolean includeAttr) throws OdaException {
        this.xPathExpression = xPathExpression;
        final boolean includeAttribute = includeAttr;
        this.treeViewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem currentItem = (TreeItem)event.item;
                if (((TreeNodeData)currentItem.getData()).hasBeenExpandedOnce()) {
                    return;
                }
                ((TreeNodeData)currentItem.getData()).setHasBeenExpandedOnce();
                currentItem.removeAll();
                try {
                    if (((TreeNodeData)currentItem.getData()).getTreeNode().getChildren() != null && ((TreeNodeData)currentItem.getData()).getTreeNode().getChildren().length > 0) {
                        TreePopulationUtil.populateTreeItems(currentItem, ((TreeNodeData)currentItem.getData()).getTreeNode().getChildren(), includeAttribute);
                    }
                }
                catch (OdaException e) {
                    ExceptionHandler.showException(null, Messages.getString("error.label"), e.getMessage(), e);
                }
            }
        });
        Object[] childs = treeNode.getChildren();
        this.populateTreeItems(this.treeViewer.getTree(), childs, 0, includeAttribute);
    }

    Button getSingleButton() {
        return this.btnSingleAdd;
    }

    Button getMultiButton() {
        return this.btnMultiAdd;
    }

    Tree getTree() {
        return this.treeViewer.getTree();
    }

    Composite getBtnComposite() {
        return this.btnComposite;
    }

    private void populateTreeItems(Object tree, Object[] node, int level, boolean includeAttribute) throws OdaException {
        ++level;
        int i = 0;
        while (i < node.length) {
            block13: {
                TreeItem treeItem;
                TreeNodeData data;
                ATreeNode treeNode;
                block14: {
                    int type;
                    block12: {
                        treeNode = (ATreeNode)node[i];
                        data = new TreeNodeData(treeNode);
                        type = treeNode.getType();
                        if (type != 2) break block12;
                        if (!includeAttribute) break block13;
                        treeItem = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItem.setData((Object)data);
                        treeItem.setImage(TreeNodeDataUtil.getColumnImage());
                        treeItem.setText(String.valueOf(ATTRIBUTE_MARK) + treeNode.getValue().toString());
                        break block14;
                    }
                    if (type == 1) {
                        treeItem = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItem.setData((Object)data);
                        if (treeNode.getParent() != null && ROOT.equals(treeNode.getParent().getValue())) {
                            treeItem.setImage(TreeNodeDataUtil.getSourceFileImage());
                        } else if (treeNode.getChildren() == null || treeNode.getChildren().length == 0) {
                            treeItem.setImage(TreeNodeDataUtil.getColumnImage());
                        } else {
                            treeItem.setImage(TreeNodeDataUtil.getXmlElementImage());
                        }
                        treeItem.setText(treeNode.getValue().toString());
                    } else {
                        treeItem = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItem.setData((Object)data);
                        treeItem.setText(treeNode.getValue().toString());
                    }
                }
                ATreeNode aTreeNode = ((TreeNodeData)treeItem.getData()).getTreeNode();
                String populateString = XPathPopulationUtil.populateColumnPath((String)this.getRootPathWithOutFilter(), (String)this.generateXpathFromATreeNode(aTreeNode));
                if (populateString != null) {
                    if (populateString.equals(EMPTY_STRING)) {
                        FontData fontData = new FontData(EMPTY_STRING, 8, 1);
                        treeItem.setFont(new Font(null, fontData));
                        this.treeViewer.getTree().setSelection(new TreeItem[]{treeItem});
                        this.treeViewer.getTree().setFocus();
                        this.treeViewer.getTree().setSelection(treeItem);
                    }
                    this.setExpanded(treeItem);
                }
                if (treeNode.getChildren() != null && treeNode.getChildren().length > 0) {
                    if (level > (this.xPathExpression == null || this.xPathExpression.split(PATH_SEPERATOR).length < 5 ? 5 : this.xPathExpression.split(PATH_SEPERATOR).length)) {
                        new TreeItem(treeItem, 0);
                    } else {
                        data.setHasBeenExpandedOnce();
                        this.populateTreeItems(treeItem, treeNode.getChildren(), level, includeAttribute);
                    }
                }
            }
            ++i;
        }
    }

    private String getRootPathWithOutFilter() {
        return this.xPathExpression.replaceAll("\\Q[\\E.*\\Q]\\E", EMPTY_STRING);
    }

    private String generateXpathFromATreeNode(ATreeNode aTreeNode) {
        String columnPath = (String)aTreeNode.getValue();
        if (aTreeNode.getType() == 2) {
            columnPath = String.valueOf(ATTRIBUTE_MARK) + columnPath;
        }
        ATreeNode parent = aTreeNode.getParent();
        while (parent != null) {
            if (parent.getType() == 1 && columnPath != null && columnPath.trim().length() > 0) {
                columnPath = parent.getValue() + PATH_SEPERATOR + columnPath;
            } else if (parent.getType() == 2) {
                columnPath = String.valueOf(columnPath) + PATH_SEPERATOR + ATTRIBUTE_MARK + parent.getValue();
            }
            parent = parent.getParent();
        }
        if (!columnPath.startsWith(PATH_SEPERATOR)) {
            columnPath = String.valueOf(PATH_SEPERATOR) + columnPath;
        }
        return columnPath;
    }

    private void setExpanded(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            this.setExpanded(treeItem.getParentItem());
        }
        treeItem.setExpanded(true);
    }
}

