/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class XmlDataSetSelectionPage
extends DataSetWizardPage {
    private static final String MINUS_ONE = "-1";
    private static final String EMPTY_STRING = "";
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFile");
    private static final int ERROR_FOLDER = 1;
    private static final int ERROR_EMPTY_PATH = 2;
    private transient Text folderLocation;
    private transient Button useXMLDataSourceButton;
    private transient Button enterXMLSourceButton;
    private transient Text numberText;
    private transient Button browseFolderButton;
    private boolean selected = false;
    private boolean useDataSourceXMLDataSelected = true;
    private String fileLocation;
    private final int UNUSED_ROW_CACHE = -1;
    private final int INVALID_ROW_NUMBER = -2;
    private final int NEGATIVE_ROW_NUMBER = -4;
    private int maxRow = -1;
    private final String[] XML_FILTER = new String[]{"*.xml", "*.*"};

    public XmlDataSetSelectionPage() {
        this(Messages.getString("wizard.title.newDataSet"));
    }

    public XmlDataSetSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XMLSample_ID");
    }

    public Control createPageControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createRadioButtons(composite);
        this.createNumOfLinesGroup(composite);
        return composite;
    }

    private void initializeControl() {
        String xmlFile;
        DataSetDesign dataSetDesign = this.getDataSetDesign();
        if (dataSetDesign == null) {
            return;
        }
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(dataSetDesign);
        }
        if ((xmlFile = XMLInformationHolder.getPropertyValue("XML_FILE")) == null || xmlFile.trim().length() == 0) {
            this.useDataSourceXMLDataSelected = true;
            this.folderLocation.setText(EMPTY_STRING);
            this.enableFolderLocation(false);
        } else {
            this.useDataSourceXMLDataSelected = false;
            this.folderLocation.setText(xmlFile);
            this.enableFolderLocation(true);
        }
        this.useXMLDataSourceButton.setSelection(this.useDataSourceXMLDataSelected);
        String rowNumber = XMLInformationHolder.getPropertyValue("MAX_ROW");
        try {
            this.maxRow = Integer.parseInt(rowNumber);
            if (this.maxRow == -1 || this.maxRow == -2 || this.maxRow == -4) {
                this.maxRow = -1;
            } else {
                this.selected = true;
                this.numberText.setEnabled(this.selected);
                this.numberText.setText(rowNumber);
            }
            this.setPageStatus();
        }
        catch (NumberFormatException numberFormatException) {
            this.maxRow = -1;
        }
        this.setPageComplete(true);
        if (!this.isSessionEditable()) {
            this.getControl().setEnabled(false);
        }
    }

    private void createRadioButtons(Composite composite) {
        Composite radioGroup = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        radioGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        radioGroup.setLayoutData((Object)gridData);
        this.setupSourceSelectionButtons(radioGroup);
        this.setupXMLFolderLocation(radioGroup);
    }

    private void createNumOfLinesGroup(Composite composite) {
        Composite numOfLinesGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        numOfLinesGroup.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 8;
        numOfLinesGroup.setLayoutData((Object)gridData);
        GridData data = new GridData();
        Label previewLabel = new Label(numOfLinesGroup, 0);
        previewLabel.setText(Messages.getString("label.preview"));
        previewLabel.setData((Object)data);
        this.numberText = new Text(numOfLinesGroup, 2048);
        this.numberText.setEnabled(true);
        data = new GridData();
        Point minSize = this.numberText.computeSize(-1, -1, true);
        data.widthHint = Math.max(60, minSize.x);
        this.numberText.setLayoutData((Object)data);
        this.numberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (XmlDataSetSelectionPage.this.numberText.getText() != null && XmlDataSetSelectionPage.this.numberText.getText().trim().length() > 0) {
                    XmlDataSetSelectionPage.this.setPageStatus();
                }
            }
        });
        Label label = new Label(numOfLinesGroup, 1);
        label.setText(Messages.getString("xmlDataSetSelectionPage.messages.lineofdata"));
    }

    private void setupSourceSelectionButtons(Composite composite) {
        GridData data = new GridData(784);
        data.horizontalSpan = 3;
        this.useXMLDataSourceButton = new Button(composite, 16);
        this.useXMLDataSourceButton.setSelection(true);
        this.useXMLDataSourceButton.setText(Messages.getString("label.useXMLFileFromDataSource"));
        this.useXMLDataSourceButton.setLayoutData((Object)data);
        this.useXMLDataSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlDataSetSelectionPage.this.useDataSourceXMLDataSelected = !XmlDataSetSelectionPage.this.useDataSourceXMLDataSelected;
                if (XmlDataSetSelectionPage.this.useDataSourceXMLDataSelected) {
                    XmlDataSetSelectionPage.this.enableFolderLocation(false);
                    XmlDataSetSelectionPage.this.fileLocation = XmlDataSetSelectionPage.EMPTY_STRING;
                } else {
                    XmlDataSetSelectionPage.this.enableFolderLocation(true);
                    XmlDataSetSelectionPage.this.fileLocation = XmlDataSetSelectionPage.this.folderLocation.getText();
                }
                XmlDataSetSelectionPage.this.setXMLFileLocaiton();
                XmlDataSetSelectionPage.this.setPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData sourceData = new GridData(784);
        sourceData.horizontalSpan = 3;
        sourceData.verticalIndent = 8;
        this.enterXMLSourceButton = new Button(composite, 16);
        this.enterXMLSourceButton.setLayoutData((Object)sourceData);
        this.enterXMLSourceButton.setText(Messages.getString("lable.selectXmlFile"));
    }

    private void enableFolderLocation(boolean enable) {
        this.enterXMLSourceButton.setSelection(enable);
        this.folderLocation.setEnabled(enable);
        this.browseFolderButton.setEnabled(enable);
    }

    private void setPageStatus() {
        if (this.numberText == null) {
            this.setMessage(DEFAULT_MESSAGE);
            return;
        }
        String rowNumber = this.numberText.getText();
        this.maxRow = this.validateRowNumber(rowNumber);
        if (this.maxRow == -2 || this.maxRow == -4) {
            this.setPageComplete(false);
            this.setDetailsMessage(Messages.getString("error.dataset.maxRowNumberError"), 3);
        } else {
            XMLInformationHolder.setPropertyValue("MAX_ROW", Integer.toString(this.maxRow));
            this.setPageComplete(true);
            this.setMessage(DEFAULT_MESSAGE);
        }
    }

    private int validateRowNumber(String maxRow) {
        if (maxRow.trim().length() == 0) {
            return -1;
        }
        int rowNumber = 0;
        try {
            rowNumber = Integer.parseInt(maxRow);
        }
        catch (NumberFormatException numberFormatException) {
            return -2;
        }
        if (rowNumber < 0) {
            return -4;
        }
        return rowNumber;
    }

    private void setupXMLFolderLocation(Composite composite) {
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Button blankButton = new Button(composite, 16);
        GridData blankBtnData = new GridData();
        blankBtnData.horizontalSpan = 1;
        blankBtnData.horizontalAlignment = 1;
        blankButton.setLayoutData((Object)blankBtnData);
        blankButton.setVisible(false);
        GridData txtGridData = new GridData(768);
        txtGridData.horizontalSpan = 1;
        this.folderLocation = new Text(composite, 2048);
        this.folderLocation.setLayoutData((Object)txtGridData);
        this.setPageComplete(false);
        this.folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlDataSetSelectionPage.this.setXMLFileLocaiton();
            }
        });
        GridData browseBtnData = new GridData();
        browseBtnData.horizontalSpan = 1;
        browseBtnData.horizontalIndent = 10;
        this.browseFolderButton = new Button(composite, 0);
        this.browseFolderButton.setText(Messages.getString("file.choose"));
        this.browseFolderButton.setLayoutData((Object)browseBtnData);
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(XmlDataSetSelectionPage.this.XML_FILTER);
                if (XmlDataSetSelectionPage.this.folderLocation.getText() != null && XmlDataSetSelectionPage.this.folderLocation.getText().trim().length() > 0) {
                    dialog.setFilterPath(XmlDataSetSelectionPage.this.folderLocation.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    XmlDataSetSelectionPage.this.folderLocation.setText(selectedLocation);
                    XmlDataSetSelectionPage.this.setXMLFileLocaiton();
                }
            }
        });
    }

    private int varifyFileLocation(String fileLocation) {
        int result;
        block6: {
            result = 0;
            if (fileLocation != null && fileLocation.trim().length() > 0) {
                try {
                    new URL(fileLocation);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(fileLocation);
                    if (file.exists()) {
                        this.setMessage(DEFAULT_MESSAGE);
                        break block6;
                    }
                    this.setDetailsMessage(Messages.getString("error.selectFolder"), 3);
                    result = 1;
                }
            } else if (!this.useDataSourceXMLDataSelected) {
                this.setDetailsMessage(Messages.getString("error.emptyPath"), 3);
                result = 2;
            }
        }
        return result;
    }

    private void setXMLFileLocaiton() {
        this.fileLocation = this.useDataSourceXMLDataSelected ? EMPTY_STRING : (this.folderLocation.getText() == null ? EMPTY_STRING : this.folderLocation.getText());
        XMLInformationHolder.setPropertyValue("XML_FILE", this.fileLocation);
    }

    private DataSetDesign getDataSetDesign() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        return dataSetDesign;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        try {
            this.savePage(design);
        }
        catch (OdaException odaException) {}
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) throws OdaException {
        if (XMLInformationHolder.hasDestroyed()) {
            return;
        }
        if (dataSetDesign.getPrivateProperties() == null) {
            try {
                dataSetDesign.setPrivateProperties(DesignSessionUtil.createDataSetNonPublicProperties((String)dataSetDesign.getOdaExtensionDataSourceId(), (String)dataSetDesign.getOdaExtensionDataSetId(), (Properties)XmlDataSetSelectionPage.getPageProperties()));
            }
            catch (OdaException odaException) {}
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            if (dataSetDesign.getPrivateProperties().findProperty("XML_FILE") != null) {
                dataSetDesign.getPrivateProperties().findProperty("XML_FILE").setNameValue("XML_FILE", XMLInformationHolder.getPropertyValue("XML_FILE"));
            }
            if (dataSetDesign.getPrivateProperties().findProperty("MAX_ROW") != null) {
                dataSetDesign.getPrivateProperties().findProperty("MAX_ROW").setNameValue("MAX_ROW", XMLInformationHolder.getPropertyValue("MAX_ROW"));
            }
        }
    }

    public IWizardPage getNextPage() {
        int result = this.varifyFileLocation(this.fileLocation);
        boolean doNext = true;
        if (result == 1) {
            doNext = MessageDialog.openQuestion((Shell)this.getShell(), (String)DEFAULT_MESSAGE, (String)Messages.getFormattedString("xmlDataSetSelectionPage.warning.errorReadXMLFile", new Object[]{this.fileLocation, Messages.getString("error.selectFolder")}));
        } else if (result == 2) {
            doNext = MessageDialog.openQuestion((Shell)this.getShell(), (String)DEFAULT_MESSAGE, (String)Messages.getFormattedString("xmlDataSetSelectionPage.warning.errorReadXMLFile", new Object[]{this.fileLocation, Messages.getString("error.emptyPath")}));
        }
        if (this.isValid() && doNext) {
            XMLInformationHolder.setPropertyValue("MAX_ROW", Integer.toString(this.maxRow));
            return super.getNextPage();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.isValid();
    }

    private boolean isValid() {
        return this.maxRow == -1 || this.maxRow >= 0;
    }

    private static Properties getPageProperties() {
        Properties prop = new Properties();
        prop.setProperty("XML_FILE", EMPTY_STRING);
        prop.setProperty("MAX_ROW", MINUS_ONE);
        return prop;
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    protected boolean canLeave() {
        this.setPageStatus();
        return this.isValid();
    }

    private void setDetailsMessage(String message, int type) {
        this.setMessage(message, type);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    protected void cleanup() {
        XMLInformationHolder.destory();
    }
}

