/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.core.common.IColumnDataAccessor;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData;
import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.Messages;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class TableDataCellModifier
implements ICellModifier {
    protected static final int MAX_LENGTH = 1000;
    protected TableDataEditor editor;
    protected TableViewer viewer;
    protected boolean canModify = false;
    protected boolean isModifying = false;

    public TableDataCellModifier(TableDataEditor editor, TableViewer viewer) {
        this.editor = editor;
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        if (!this.canModify) {
            return false;
        }
        if (this.editor.isReadonly()) {
            return false;
        }
        int col = this.getColumnIndex(property);
        if (this.isColumnGenerated(col)) {
            return false;
        }
        ITableData tableData = this.editor.getTableData();
        if (element instanceof IRowData) {
            Object val = ((IRowData)element).getValue(col);
            int type = tableData.getColumnType(col);
            IColumnDataAccessor acc = tableData.getColumnDataAccessor(col);
            if (!acc.supportsInlineEdit() || acc.isSnippet(val, type)) {
                return false;
            }
            String s = acc.serialize(val, type);
            if (s != null && s.length() > 1000) {
                return false;
            }
        }
        return true;
    }

    protected boolean isColumnGenerated(int colIndex) {
        Column sqlCol = (Column)this.editor.getSqlTable().getColumns().get(colIndex);
        return sqlCol.getIdentitySpecifier() != null;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public Object getValue(Object element, String property) {
        int col = this.getColumnIndex(property);
        if (!(element instanceof IRowData)) {
            return "";
        }
        IRowData row = (IRowData)element;
        try {
            Object o = row.getValue(col);
            String s = row.getTable().getColumnDataAccessor(col).serialize(o, row.getTable().getColumnType(col));
            return s == null ? "" : s;
        }
        catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            return Messages.getString("TableDataCellModifier.error");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modify(Object element, String property, Object value) {
        int column = this.getColumnIndex(property);
        if (this.isModifying) {
            return;
        }
        try {
            this.isModifying = true;
            IRowData row = this.editor.getOrCreateRow();
            Object oldObject = row.getValue(column);
            String oldString = row.getTable().getColumnDataAccessor(column).serialize(oldObject, row.getTable().getColumnType(column));
            if (value.equals(oldString)) {
                Object var10_8 = null;
                this.isModifying = false;
                return;
            }
            try {
                this.editor.setDirty(true);
                Object o = row.getTable().getColumnDataAccessor(column).deserialize((String)value, row.getTable().getColumnType(column));
                row.updateValue(column, o);
                if (element instanceof TableItem) {
                    this.editor.setDirtyBackground(column, (TableItem)element);
                }
            }
            catch (Exception ex) {
                Status warning = new Status(4, "org.eclipse.datatools.sqltools.data.ui", 1, Messages.getString("TableDataCellModifier.dataFormatError"), (Throwable)ex);
                ErrorDialog.openError((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("TableDataCellModifier.ErrorUpdatingData"), null, (IStatus)warning);
            }
            this.viewer.refresh((Object)row);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.isModifying = false;
            throw throwable;
        }
        {
            Object var10_10 = null;
            this.isModifying = false;
            return;
        }
    }

    protected int getColumnIndex(String property) {
        Object[] properties = this.viewer.getColumnProperties();
        int col = 0;
        while (properties[col] != property && col < properties.length) {
            ++col;
        }
        if (col == properties.length) {
            return -1;
        }
        return col;
    }
}

