/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.sqlbuilderdialog;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.common.ui.dialog.SQLPainterDlg;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.datatools.sqltools.sqlbuilder.IExecuteSQLListener;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.ParseException;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ISQLStatementInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStatementInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.sqlbuilderdialog.ResultsHistoryFilter;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLFileUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SQLBuilderDialog
extends SQLPainterDlg
implements IExecuteSQLListener {
    public static final String DIALOG_TITLE = Messages._UI_SQLQUERYBUILDERDIALOG_NAME;
    public static final String TAB_EDITOR = Messages.SQLQueryBuilderDialogEditTabName;
    public static final String TAB_RESULTS = Messages.SQLQueryBuilderDialogResultsTabName;
    private static final String LEFT_BRACKET = " <";
    private static final String RIGHT_BRACKET = ">";
    private static final String EMPTY_STRING = "";
    CTabFolder _tabFolder;
    CTabItem _tabItemResults;
    private SQLBuilder _sqlBuilder = null;
    private IFile _file = null;
    private ISQLEditorConnectionInfo _connectionInfo = null;
    private ISQLBuilderEditorInput _editorInput = null;
    ResultsViewControl _resultsViewControl;
    ViewerFilter[] _resultViewFilters;

    public SQLBuilderDialog(Shell parentShell, String statementType, String statement, String profileName, String database, String parametersType, String parameter, String table, HashMap info) {
        super(parentShell, statementType, statement, profileName, database, parametersType, parameter, table, info);
        this.initDialog();
    }

    protected SQLBuilderDialog(Shell parentShell) {
        super(parentShell, null, null, null, null, null, null);
        this.initDialog();
    }

    private void initDialog() {
        this.setShellStyle(67696);
        this._sqlBuilder = new SQLBuilder();
    }

    protected SQLBuilder getSQLBuilder() {
        return this._sqlBuilder;
    }

    public String load() {
        SQLBuilderEditorInput input;
        IOmitSchemaInfo omitSchemaInfo;
        Object value;
        try {
            this._connectionInfo = new SQLBuilderConnectionInfo(ProfileUtil.getProfile((String)this._profileName));
        }
        catch (NoSuchProfileException e1) {
            e1.printStackTrace();
        }
        this._file = null;
        if (this._info != null && !this._info.isEmpty() && (value = this._info.get("file")) instanceof IFile) {
            this._file = (IFile)value;
        }
        if (this._file != null) {
            omitSchemaInfo = SQLFileUtil.getOmitSchemaInfo(this._file);
        } else {
            omitSchemaInfo = new OmitSchemaInfo();
            omitSchemaInfo.initFromPreferences();
        }
        if (this._statement != null && this._statement.length() > 0) {
            input = new SQLBuilderEditorInput(this._connectionInfo, (ISQLStatementInfo)new SQLStatementInfo(this._statement), omitSchemaInfo);
        } else {
            input = new SQLBuilderEditorInput(this._connectionInfo, 0);
            input.setOmitSchemaInfo(omitSchemaInfo);
        }
        boolean isInputLoaded = this.setInput(input);
        if (!isInputLoaded) {
            String sMessage = Messages.SQLQueryBuilderDialogParseFailOnOpenAskUserMessage;
            boolean bContinue = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)Messages.SQLQueryBuilderDialogParseFailOnOpenAskUserTitle, (String)sMessage);
            if (!bContinue) {
                return null;
            }
        }
        this.setBlockOnOpen(true);
        if (this.open() == 0) {
            return this.getSQL();
        }
        return null;
    }

    protected boolean setInput(ISQLBuilderEditorInput editorInput) {
        this._editorInput = editorInput;
        try {
            this._sqlBuilder.setInput(this._editorInput);
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setSize(shell.computeSize(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds().width * 2 / 3, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds().height * 2 / 3));
    }

    public Control createDialogArea(Composite parent) {
        if (this._editorInput == null) {
            Shell shell = new Shell();
            MessageDialog.openInformation((Shell)shell, (String)DIALOG_TITLE, (String)Messages.SQLQueryBuilderDialogNoInput);
            return null;
        }
        String dialogTitle = DIALOG_TITLE;
        if (this._editorInput.getName() != null && this._editorInput.getName().length() > 0) {
            dialogTitle = String.valueOf(dialogTitle) + LEFT_BRACKET + this._editorInput.getName() + RIGHT_BRACKET;
        }
        parent.getShell().setText(dialogTitle);
        Composite topComposite = this.createMainComposite(parent);
        this._tabFolder = this.createTabFolder(topComposite, 1024);
        CTabItem tabEditor = this.createTabItem(this._tabFolder, 0, 0, TAB_EDITOR);
        Composite editComposite = this.createMainComposite((Composite)this._tabFolder);
        tabEditor.setControl((Control)editComposite);
        this._sqlBuilder.createClient(editComposite);
        this._sqlBuilder.addExecuteSQLListener(this);
        this._tabItemResults = this.createTabItem(this._tabFolder, 0, 1, TAB_RESULTS);
        Composite resultsComposite = this.createMainComposite((Composite)this._tabFolder);
        this._tabItemResults.setControl((Control)resultsComposite);
        this._resultsViewControl = new ResultsViewControl();
        this._resultsViewControl.setUsePreferences(true);
        try {
            this._resultsViewControl.init();
        }
        catch (PartInitException e) {
            System.out.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        this._resultsViewControl.createPartControl(resultsComposite);
        GridData gd = new GridData(4, 4, true, true);
        this._resultsViewControl.getControl().setLayoutData((Object)gd);
        this.filterResultsView(this._editorInput.getConnectionInfo().getConnectionProfile());
        ResultsViewAPI.getInstance().setCheckSRV(false);
        this._tabFolder.setSelection(tabEditor);
        return topComposite;
    }

    private void filterResultsView(IConnectionProfile connectionProfile) {
        ViewerFilter[] filters = this._resultViewFilters;
        if (filters == null || filters.length == 0) {
            filters = new ViewerFilter[]{new ResultsHistoryFilter(connectionProfile.getName())};
        }
        int i = 0;
        while (i < filters.length) {
            this._resultsViewControl.addResultHistoryFilter(filters[i]);
            ++i;
        }
    }

    protected void setResultViewFilters(ViewerFilter[] filters) {
        this._resultViewFilters = filters;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this._file != null) {
                this._sqlBuilder.saveOmitSchemaInfo(this._file);
            }
            this.setReturnCode(0);
            this.close();
        } else if (buttonId == 1) {
            this.setReturnCode(1);
            this.close();
        }
    }

    public boolean isDirty() {
        String sCurrentSQL = this._sqlBuilder.getSQL();
        if (sCurrentSQL == null) {
            sCurrentSQL = EMPTY_STRING;
        }
        return !sCurrentSQL.equals(this._statement);
    }

    public String getSQL() {
        return this._sqlBuilder.getSQL();
    }

    private Composite createMainComposite(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout mainCompLayout = new GridLayout(1, true);
        mainComposite.setLayout((Layout)mainCompLayout);
        GridData gd = new GridData(4, 4, true, true);
        mainComposite.setLayoutData((Object)gd);
        return mainComposite;
    }

    private CTabFolder createTabFolder(Composite parent, int style) {
        CTabFolder tabFolder = new CTabFolder(parent, style);
        GridLayout mainCompLayout = new GridLayout(1, true);
        tabFolder.setLayout((Layout)mainCompLayout);
        GridData gd = new GridData(4, 4, true, true);
        tabFolder.setLayoutData((Object)gd);
        return tabFolder;
    }

    private CTabItem createTabItem(CTabFolder tabFolder, int style, int tabNum, String name) {
        CTabItem tabItem = new CTabItem(tabFolder, style, tabNum);
        tabItem.setText(name);
        return tabItem;
    }

    public boolean close() {
        ResultsViewAPI.getInstance().setCheckSRV(true);
        this._sqlBuilder.removeExecuteSQLListener(this);
        this._resultsViewControl.dispose();
        return super.close();
    }

    public void executedSQL() {
        this._tabFolder.setSelection(this._tabItemResults);
    }

    protected CTabFolder getTabFolder() {
        return this._tabFolder;
    }
}

