/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.apache.internal.derby.ddl.DerbyDdlParser;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCView;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogView
extends JDBCView {
    private static final long serialVersionUID = 3258125856181269553L;
    private boolean viewLoaded = false;

    public void refresh() {
        this.viewLoaded = false;
        super.refresh();
    }

    public QueryExpression getQueryExpression() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.queryExpression;
    }

    public CheckType getCheckType() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.checkType;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getColumns();
        }
        if (id == 18) {
            this.getCheckType();
        }
        if (id == 17) {
            this.getQueryExpression();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadView() {
        if (this.viewLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Statement s = connection.createStatement();
            String query = " SELECT CHECKOPTION, VIEWDEFINITION FROM SYS.SYSVIEWS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.TABLEID=B.TABLEID AND B.TABLENAME='" + this.getName() + "'" + " AND B.SCHEMAID=C.SCHEMAID" + " AND C.SCHEMANAME='" + this.getSchema().getName() + "'";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String viewCheck = r.getString("CHECKOPTION");
                if (viewCheck.equals("N")) {
                    this.setCheckType(CheckType.NONE_LITERAL);
                } else if (viewCheck.equals("L")) {
                    this.setCheckType(CheckType.LOCAL_LITERAL);
                } else if (viewCheck.equals("C")) {
                    this.setCheckType(CheckType.CASCADED_LITERAL);
                }
                String text = r.getString("VIEWDEFINITION");
                DerbyDdlParser ddlParser = new DerbyDdlParser(this.getDatabaseDefinition());
                ddlParser.parseView((ViewTable)this, text);
            }
            this.viewLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    public Table getSupertable() {
        return null;
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getCatalog().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }
}

