/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.internal.impl;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConsumerPlugin;

public class LogPathHelper {
    private static final String LOG_SUBFOLDER_NAME = "logs";

    static IPath getPluginLogPath() throws IllegalStateException {
        OdaConsumerPlugin thePlugin = OdaConsumerPlugin.getDefault();
        if (thePlugin == null) {
            throw new IllegalStateException("OdaConsumerPlugin.getDefault()");
        }
        return thePlugin.getStateLocation().append(LOG_SUBFOLDER_NAME);
    }

    static File getConsumerLogParent(String subdirName) {
        IPath pluginLogPath = LogPathHelper.getPluginLogPath();
        if (subdirName == null || subdirName.length() == 0) {
            return pluginLogPath.toFile();
        }
        return pluginLogPath.append(subdirName).toFile();
    }

    public static String getAbsoluteLogDirName(String logDirectory) {
        if (logDirectory == null || logDirectory.length() == 0) {
            return null;
        }
        File logParent = new File(logDirectory);
        if (logParent.isAbsolute()) {
            return logDirectory;
        }
        return LogPathHelper.getConsumerLogParent(logDirectory).getPath();
    }
}

