/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IColumnNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.enablement.sybase.Messages;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseBaseTable;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.ui.util.DSEUtil;
import org.eclipse.datatools.enablement.sybase.virtual.CheckConstraintNode;
import org.eclipse.datatools.enablement.sybase.virtual.ForeignKeyNode;
import org.eclipse.datatools.enablement.sybase.virtual.PrimaryKeyNode;
import org.eclipse.datatools.enablement.sybase.virtual.UniqueConstraintNode;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.ecore.EObject;

public class DSEContentProviderUtil {
    public static ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    public static final IVirtualNodeServiceFactory nodeFactory = IDataToolsUIServiceManager.INSTANCE.getVirtualNodeServiceFactory();
    protected static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    public static final String TRIGGER = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TRIGGER");
    public static final String INDEX = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.INDEX");
    public static final String CONSTRAINT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.CONSTRAINT");
    public static final String COLUMN = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.COLUMN");
    public static final String DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DEPENDENCY");
    public static final String PRIMARY_KEY_FOLDER = Messages.getString((String)"PrimaryKey_folder_name");
    public static final String UNIQUE_CONSTRAINT_FOLDER = Messages.getString((String)"UniqueConstraint_folder_name");
    public static final String CHECK_CONSTRAINT_FOLDER = Messages.getString((String)"CheckConstraint_folder_name");
    public static final String FOREIGN_KEY_FOLDER = Messages.getString((String)"ForeignKey_folder_name");

    public static Object[] getTableChildren(Object parent) {
        if (!(parent instanceof Table)) {
            return new Object[0];
        }
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition df = dbRegistry.getDefinition(((Table)parent).getSchema().getDatabase());
        ArrayList<Object> collection = new ArrayList<Object>(5);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        collection.add(nodeFactory.makeIndexNode(INDEX, INDEX, parent));
        collection.add((Object)new PrimaryKeyNode(PRIMARY_KEY_FOLDER, PRIMARY_KEY_FOLDER, parent));
        collection.add((Object)new UniqueConstraintNode(UNIQUE_CONSTRAINT_FOLDER, UNIQUE_CONSTRAINT_FOLDER, parent));
        collection.add((Object)new CheckConstraintNode(CHECK_CONSTRAINT_FOLDER, CHECK_CONSTRAINT_FOLDER, parent));
        collection.add((Object)new ForeignKeyNode(FOREIGN_KEY_FOLDER, FOREIGN_KEY_FOLDER, parent));
        return DSEContentProviderUtil.getArrays(parent, collection);
    }

    public static Object[] getViewTableChildren(Object parent) {
        if (!(parent instanceof ViewTable)) {
            return new Object[0];
        }
        ArrayList<IColumnNode> collection = new ArrayList<IColumnNode>(1);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        return DSEContentProviderUtil.getArrays(parent, collection);
    }

    public static Object[] getConstraintNodeChildren(Object parent) {
        if (parent instanceof PrimaryKeyNode) {
            return DSEContentProviderUtil.getPrimaryKeyNodeChildren(parent);
        }
        if (parent instanceof UniqueConstraintNode) {
            return DSEContentProviderUtil.getUniqueConstraintNodeChildren(parent);
        }
        if (parent instanceof CheckConstraintNode) {
            return DSEContentProviderUtil.getCheckConstraintNodeChildren(parent);
        }
        if (parent instanceof ForeignKeyNode) {
            return DSEContentProviderUtil.getForeignKeyNodeChildren(parent);
        }
        return new Object[0];
    }

    private static Object[] getPrimaryKeyNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        ArrayList<PrimaryKey> list = null;
        if (table.getPrimaryKey() != null) {
            list = new ArrayList<PrimaryKey>(1);
            list.add(table.getPrimaryKey());
        } else {
            list = new ArrayList(0);
        }
        return DSEContentProviderUtil.getArrays(parent, DSEContentProviderUtil.getChildren(((IVirtualNode)parent).getGroupID(), list));
    }

    private static Object[] getUniqueConstraintNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        ArrayList list = table.getUniqueConstraints();
        ArrayList uniqueList = null;
        if (table.getPrimaryKey() != null) {
            uniqueList = new ArrayList(list.size() - 1);
            int i = 0;
            while (i < list.size()) {
                Object obj = list.get(i);
                if (!(obj instanceof PrimaryKey)) {
                    uniqueList.add(obj);
                }
                ++i;
            }
        } else {
            uniqueList = list;
        }
        return DSEContentProviderUtil.getArrays(parent, DSEContentProviderUtil.getChildren(((IVirtualNode)parent).getGroupID(), uniqueList));
    }

    private static Object[] getCheckConstraintNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        if (table instanceof SybaseBaseTable) {
            SybaseBaseTable sybaseTable = (SybaseBaseTable)table;
            return DSEContentProviderUtil.getArrays(parent, DSEContentProviderUtil.getChildren(((IVirtualNode)parent).getGroupID(), sybaseTable.getCheckConstraints()));
        }
        return new Object[0];
    }

    private static Object[] getForeignKeyNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return DSEContentProviderUtil.getArrays(parent, DSEContentProviderUtil.getChildren(((IVirtualNode)parent).getGroupID(), table.getForeignKeys()));
    }

    private static Collection getChildren(String groupID, List children) {
        if (children == null) {
            return new ArrayList(0);
        }
        ArrayList<EObject> list = new ArrayList<EObject>(children.size());
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            list.add(child);
        }
        return list;
    }

    public static Object[] getArrays(Object parent, Collection collection) {
        if (collection.isEmpty()) {
            return EMPTY_ELEMENT_ARRAY;
        }
        if (parent instanceof IVirtualNode && !((IVirtualNode)parent).hasChildren()) {
            ((IVirtualNode)parent).addChildren(collection);
        }
        return collection.toArray(new Object[collection.size()]);
    }

    public static String getUDTDisplayNameFormatedText(Object obj) {
        if (obj == null || !(obj instanceof DistinctUserDefinedType)) {
            return "";
        }
        Schema schema = ((DistinctUserDefinedType)obj).getSchema();
        DistinctUserDefinedType udt = (DistinctUserDefinedType)obj;
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = dbRegistry.getDefinition(schema.getDatabase());
        if (definition != null) {
            PredefinedDataType dataType = udt.getPredefinedRepresentation();
            if (dataType != null) {
                return String.valueOf(udt.getLabel()) + " [" + definition.getPredefinedDataTypeFormattedName(dataType) + "]";
            }
            return udt.getLabel();
        }
        return udt.getLabel();
    }

    public static String getParameterDisplayNameFormatedText(Object obj) {
        if (obj == null || !(obj instanceof SybaseParameter)) {
            return "";
        }
        Schema schema = ((SybaseParameter)obj).getRoutine().getSchema();
        SybaseParameter parameter = (SybaseParameter)obj;
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = dbRegistry.getDefinition(schema.getDatabase());
        if (definition != null) {
            DataType dataType = parameter.getDataType();
            String dataTypeStr = null;
            if (dataType != null) {
                dataTypeStr = dataType instanceof PredefinedDataType ? definition.getPredefinedDataTypeFormattedName((PredefinedDataType)dataType) : dataType.getName();
            }
            return String.valueOf(parameter.getName()) + " [" + dataTypeStr + "]";
        }
        return parameter.getName();
    }

    public static List appendOwnerToLabel(List sqlObjects, String owner, boolean isShowOwner) {
        if (owner == null) {
            return sqlObjects;
        }
        String ownerLabel = "(" + owner + ")";
        if (isShowOwner) {
            Iterator iterator = sqlObjects.iterator();
            while (iterator.hasNext()) {
                SQLObject sqlObj;
                Object obj = iterator.next();
                if (!(obj instanceof SQLObject) || (sqlObj = (SQLObject)obj).getLabel() != null && !sqlObj.getLabel().equals(sqlObj.getName())) continue;
                sqlObj.setLabel(String.valueOf(sqlObj.getName()) + " " + ownerLabel);
            }
        } else {
            Iterator iterator = sqlObjects.iterator();
            while (iterator.hasNext()) {
                SQLObject sqlObj;
                Object obj = iterator.next();
                if (!(obj instanceof SQLObject) || (sqlObj = (SQLObject)obj).getLabel() != null && sqlObj.getLabel().equals(sqlObj.getName())) continue;
                sqlObj.setLabel(sqlObj.getName());
            }
        }
        return sqlObjects;
    }

    public static boolean isObjectRenamed(SQLObject sqlObject) {
        String label = sqlObject.getLabel();
        String name = sqlObject.getName();
        if (label != null && label.indexOf("(") == -1) {
            return !label.equals(name);
        }
        return label != null && !label.substring(0, label.indexOf("(") - 1).equals(name);
    }

    public static String appendOwnerToLabel(String label, String owner) {
        String ownerLabel = "(" + owner + ")";
        return label == null ? null : String.valueOf(label) + " " + ownerLabel;
    }

    public static String appendOwnerToLabel(SQLObject element) {
        if (element.getLabel() == null) {
            return element.getName();
        }
        if (DSEContentProviderUtil.isObjectRenamed(element)) {
            if (DSEUtil.checkIsShowOwner(element)) {
                element.setLabel(DSEContentProviderUtil.appendOwnerToLabel(element.getName(), ModelUtil.getSchema((EObject)element).getOwner().getName()));
            } else {
                element.setLabel(element.getName());
            }
        }
        return element.getLabel();
    }
}

