/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.EClass;

public class SQL2005RoutineLoader
extends JDBCRoutineLoader {
    public static final String COLUMN_ROUTINE_NAME = "ROUTINE_NAME";
    public static final String COLUMN_ROUTINE_CATALOG = "SPECIFIC_CATALOG";
    public static final String COLUMN_ROUTINE_SCHEMA = "SPECIFIC_SCHEMA";
    public static final String COLUMN_ROUTINE_TYPE = "ROUTINE_TYPE";
    public static final String COLUMN_ROUTINE_DEFINITION = "ROUTINE_DEFINITION";
    private JDBCRoutineLoader.IRoutineFactory mUserDefinedFunctionFactory;
    private JDBCRoutineLoader.IRoutineFactory mProcedureFactory;

    public SQL2005RoutineLoader() {
        super(null);
    }

    public SQL2005RoutineLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    public SQL2005RoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        this.mUserDefinedFunctionFactory = new SQL2005UserDefinedFunctionFactory();
        this.mProcedureFactory = new SQL2005ProcedureFactory();
    }

    public SQL2005RoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, JDBCRoutineLoader.IRoutineFactory udfFactory, JDBCRoutineLoader.IRoutineFactory spFactory) {
        super(catalogObject, connectionFilterProvider, udfFactory, spFactory);
    }

    protected ResultSet createResultSet() throws SQLException {
        String schemaName = this.getSchema().getName();
        String catalogName = this.getSchema().getCatalog().getName();
        String query = "select INFORMATION_SCHEMA.ROUTINES.SPECIFIC_CATALOG as 'SPECIFIC_CATALOG', INFORMATION_SCHEMA.ROUTINES.SPECIFIC_SCHEMA as 'SPECIFIC_SCHEMA', INFORMATION_SCHEMA.ROUTINES.ROUTINE_NAME as 'ROUTINE_NAME', INFORMATION_SCHEMA.ROUTINES.ROUTINE_DEFINITION as 'ROUTINE_DEFINITION', INFORMATION_SCHEMA.ROUTINES.ROUTINE_TYPE as 'ROUTINE_TYPE' from INFORMATION_SCHEMA.ROUTINES where INFORMATION_SCHEMA.ROUTINES.SPECIFIC_CATALOG = '" + catalogName + "' and " + "INFORMATION_SCHEMA.ROUTINES.SPECIFIC_SCHEMA = '" + schemaName + "'";
        if (this.getJDBCFilterPattern() != null && this.getJDBCFilterPattern().length() > 0) {
            String filter = " AND ALIAS LIKE " + this.getJDBCFilterPattern();
            query = String.valueOf(query) + filter;
        }
        query = String.valueOf(query) + " ORDER BY " + COLUMN_ROUTINE_NAME;
        Statement s = this.getCatalogObject().getConnection().createStatement();
        ResultSet r = s.executeQuery(query);
        return r;
    }

    protected boolean isProcedure(ResultSet rs) throws SQLException {
        return rs.getString(COLUMN_ROUTINE_TYPE).startsWith("P");
    }

    public JDBCRoutineLoader.IRoutineFactory getProcedureFactory() {
        return this.mProcedureFactory;
    }

    public JDBCRoutineLoader.IRoutineFactory getUserDefinedFunctionFactory() {
        return this.mUserDefinedFunctionFactory;
    }

    protected Routine processRow(ResultSet rs) throws SQLException {
        ICatalogObject object = this.getCatalogObject();
        Database database = object.getCatalogDatabase();
        if (this.mProcedureFactory == null) {
            this.mProcedureFactory = new SQL2005ProcedureFactory();
            ((SQL2005ProcedureFactory)this.mProcedureFactory).setDatabase(database);
        }
        if (this.mUserDefinedFunctionFactory == null) {
            this.mUserDefinedFunctionFactory = new SQL2005UserDefinedFunctionFactory();
            ((SQL2005UserDefinedFunctionFactory)this.mUserDefinedFunctionFactory).setDatabase(database);
        }
        JDBCRoutineLoader.IRoutineFactory routineFactory = this.isProcedure(rs) ? this.mProcedureFactory : this.mUserDefinedFunctionFactory;
        return routineFactory.createRoutine(rs);
    }

    /*
     * Exception decompiling
     */
    public void loadRoutines(List containmentList, Collection existingRoutines) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 216->220)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadSource(Routine routine, String aliasInfo, Database database) {
        if (aliasInfo == null || aliasInfo.trim().length() == 0) {
            return;
        }
        int index = aliasInfo.indexOf("begin");
        if (index == -1) {
            return;
        }
        String body = aliasInfo.substring(index);
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = definition.getDataModelElementFactory();
        Source s = (Source)factory.create(SQLRoutinesPackage.eINSTANCE.getSource());
        s.setBody(body);
        routine.setSource(s);
    }

    public static class SQL2005ProcedureFactory
    extends JDBCRoutineLoader.ProcedureFactory {
        private Database database = null;

        public void setDatabase(Database db) {
            this.database = db;
        }

        public void initialize(Routine routine, ResultSet rs) throws SQLException {
            String name = rs.getString(SQL2005RoutineLoader.COLUMN_ROUTINE_NAME);
            if (name.indexOf(";") > -1) {
                name = name.substring(0, name.indexOf(";") - 1);
            }
            routine.setName(name);
            String source = rs.getString(SQL2005RoutineLoader.COLUMN_ROUTINE_DEFINITION);
            SQL2005RoutineLoader.loadSource(routine, source, this.database);
        }
    }

    public static class SQL2005UserDefinedFunctionFactory
    extends SQL2005ProcedureFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
        }

        protected Routine newRoutine() {
            return new JDBCUserDefinedFunction();
        }
    }
}

