/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.common.data;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.BigDecimalFormat;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.BigIntegerFormat;

public class DataSerializer {
    protected static final int[] NEEDS_QUOTE = new int[]{-7, 2004, 2005, 1, 12, -1, -2, -3, -4, 91, 92, 93, 1111};

    public static String serialize(Object val, int type) {
        if (val == null) {
            return null;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        NumberFormat intf = NumberFormat.getIntegerInstance();
        intf.setGroupingUsed(false);
        if (type == -6) {
            return intf.format(val);
        }
        if (type == 5) {
            return intf.format(val);
        }
        if (type == 4) {
            return intf.format(val);
        }
        if (type == -5) {
            if (val instanceof BigInteger) {
                return BigIntegerFormat.getInstance().format((BigInteger)val);
            }
            return intf.format(val);
        }
        if (type == 7) {
            return nf.format(val);
        }
        if (type == 6) {
            return nf.format(val);
        }
        if (type == 8) {
            return nf.format(val);
        }
        if (type == 3) {
            if (val instanceof BigDecimal) {
                return BigDecimalFormat.getInstance().format((BigDecimal)val);
            }
            return intf.format(val);
        }
        if (type == 2) {
            if (val instanceof BigDecimal) {
                return BigDecimalFormat.getInstance().format((BigDecimal)val);
            }
            return intf.format(val);
        }
        if (type == -7) {
            return val.toString();
        }
        if (type == 1) {
            return val.toString();
        }
        if (type == 12) {
            return val.toString();
        }
        if (type == -1) {
            return val.toString();
        }
        if (type == -2) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == -3) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == -4) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == 91) {
            return DataSerializer.formatDate(val);
        }
        if (type == 92) {
            return DataSerializer.formatTime(val);
        }
        if (type == 93) {
            return DataSerializer.formatTimestamp(val);
        }
        if (type == 2005) {
            return val.toString();
        }
        if (type == 2004) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == 1111) {
            return val.toString();
        }
        if (type == 2003 || type == 2006 || type == 2002 || type == 2000) {
            return null;
        }
        return val.toString();
    }

    public static String write(Object val, int type, String stringDelim) {
        String s = DataSerializer.serialize(val, type);
        if (s != null && DataSerializer.needsQuote(type)) {
            s = String.valueOf(stringDelim) + DataSerializer.doubleStringDelim(s, stringDelim) + stringDelim;
        }
        return s;
    }

    public static String doubleStringDelim(String s, String delim) {
        if (delim == null || delim.length() == 0) {
            return s;
        }
        int i = s.indexOf(delim);
        if (i != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (i != -1) {
                sb = sb.insert(i, delim);
                int j = i + 2 * delim.length();
                i = sb.toString().indexOf(delim, j);
            }
            return sb.toString();
        }
        return s;
    }

    protected static String serializeBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            int n = bytes[i];
            if (n < 0) {
                n += 256;
            }
            sb.append(Integer.toString(n / 16, 16));
            sb.append(Integer.toString(n % 16, 16));
            ++i;
        }
        return sb.toString();
    }

    public static boolean needsQuote(int type) {
        int i = 0;
        while (i < NEEDS_QUOTE.length) {
            if (NEEDS_QUOTE[i] == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String formatDate(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return DateFormat.getDateInstance((int)3).format(val);
        }
        return val.toString();
    }

    private static String formatTime(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Time) {
            return DateFormat.getTimeInstance((int)2).format(val);
        }
        return val.toString();
    }

    private static String formatTimestamp(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Timestamp) {
            return DateFormat.getDateTimeInstance((int)3, (int)2).format(val);
        }
        return val.toString();
    }
}

