/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class ProfileUIManager {
    public static boolean hasContributors(Object element) {
        return ProfileUIManager.hasPropertiesContributors(element);
    }

    public static PreferenceDialog createPreferenceDialog(Shell parentShell, Object element) {
        if (element == null || !(element instanceof IAdaptable)) {
            return null;
        }
        IPreferenceNode[] nodes = ProfileUIManager.propertiesContributorsFor(element);
        String[] displayedIds = new String[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            displayedIds[i] = nodes[i].getId();
            ++i;
        }
        PreferenceDialog propertyDialog = PreferencesUtil.createPropertyDialogOn((Shell)parentShell, (IAdaptable)((IAdaptable)element), null, (String[])displayedIds, null);
        return propertyDialog;
    }

    public static ProfilePropertyPage createPropertyPage(IConnectionProfile profile) {
        IPreferenceNode[] nodes = ProfileUIManager.propertiesContributorsFor(profile);
        int i = 0;
        while (i < nodes.length) {
            IPreferenceNode pageNode = nodes[i];
            IPreferencePage propPage = pageNode.getPage();
            if (propPage == null) {
                pageNode.createPage();
                propPage = pageNode.getPage();
            }
            if (!(propPage instanceof ProfilePropertyPage)) {
                if (propPage != null) {
                    pageNode.disposeResources();
                }
            } else {
                return (ProfilePropertyPage)propPage;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasPropertiesContributors(Object element) {
        if (element == null || !(element instanceof IAdaptable)) {
            return false;
        }
        Collection contributors = PropertyPageContributorManager.getManager().getApplicableContributors(element);
        return contributors != null && contributors.size() > 0;
    }

    public static IPreferenceNode[] propertiesContributorsFor(Object element) {
        PropertyPageManager pageManager = new PropertyPageManager();
        if (element == null) {
            return null;
        }
        PropertyPageContributorManager.getManager().contribute(pageManager, element);
        List pages = pageManager.getElements(0);
        IPreferenceNode[] nodes = new IPreferenceNode[pages.size()];
        pages.toArray(nodes);
        return nodes;
    }
}

