/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DriverTreeTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof TemplateDescriptor) {
            TemplateDescriptor td = (TemplateDescriptor)element;
            String name = td.getName();
            String vendor = td.getPropertyValueFromId("org.eclipse.datatools.connectivity.db.vendor");
            String version = td.getPropertyValueFromId("org.eclipse.datatools.connectivity.db.version");
            if (vendor == null) {
                vendor = "";
            }
            if (version == null) {
                version = "";
            }
            DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(vendor, version);
            String versionDisplay = null;
            String vendorDisplay = null;
            if (dbDef != null) {
                versionDisplay = dbDef.getVersionDisplayString();
                vendorDisplay = dbDef.getProductDisplayString();
            }
            switch (columnIndex) {
                case 0: {
                    return name;
                }
                case 1: {
                    return vendorDisplay;
                }
                case 2: {
                    return versionDisplay;
                }
            }
            return "";
        }
        if (element instanceof CategoryDescriptor) {
            CategoryDescriptor cd = (CategoryDescriptor)element;
            String name = cd.getName();
            switch (columnIndex) {
                case 0: {
                    return name;
                }
            }
            return "";
        }
        return new String();
    }

    public String getText(Object element) {
        if (element instanceof TemplateDescriptor) {
            TemplateDescriptor td = (TemplateDescriptor)element;
            String name = td.getName();
            return name;
        }
        if (element instanceof CategoryDescriptor) {
            CategoryDescriptor cd = (CategoryDescriptor)element;
            String name = cd.getName();
            return name;
        }
        return super.getText(element);
    }
}

