/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IProfileWizardProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Image;

public class ProfileWizardProvider
implements IProfileWizardProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_CATEGORY = "category";
    private String mId;
    private String mName;
    private ImageDescriptor mIcon;
    private Image mCachedIcon;
    private String mProfile;
    private String mDescription;
    private String mCategory;
    private IConfigurationElement mElement;

    public ProfileWizardProvider(IConfigurationElement element) {
        this.init(element);
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"newWizard".equals(element.getName()));
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mProfile = element.getAttribute(ATTR_PROFILE);
        this.mDescription = element.getAttribute(ATTR_DESC);
        this.mCategory = element.getAttribute(ATTR_CATEGORY);
        if (this.mCategory == null) {
            this.mCategory = "";
        }
        this.processIconAttr();
    }

    private void processIconAttr() {
        String iconAttr = this.mElement.getAttribute(ATTR_ICON);
        if (iconAttr != null && iconAttr.trim().length() > 0) {
            URL url = null;
            if (iconAttr.startsWith("platform:/")) {
                try {
                    url = new URL(iconAttr);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                url = Platform.getBundle((String)this.mElement.getContributor().getName()).getEntry(iconAttr);
            }
            this.mIcon = ImageDescriptor.createFromURL((URL)url);
        } else {
            this.mIcon = ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public String getDescription() {
        return this.mDescription;
    }

    public ImageDescriptor getIcon() {
        return this.mIcon;
    }

    public Image getCachedIcon() {
        if (this.mCachedIcon == null) {
            this.mCachedIcon = this.mIcon.createImage();
        }
        return this.mCachedIcon;
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getProfile() {
        return this.mProfile;
    }

    public String getCategory() {
        return this.mCategory;
    }

    public IWizard getWizard() {
        final IWizard[] result = new IWizard[1];
        SafeRunnable code = new SafeRunnable(ConnectivityPlugin.getDefault().getResourceString("dialog.title.error.loadwizard", new Object[]{this.mElement.getDeclaringExtension().getNamespaceIdentifier()})){

            public void run() throws Exception {
                result[0] = (IWizard)ProfileWizardProvider.this.mElement.createExecutableExtension(ProfileWizardProvider.ATTR_CLASS);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return result[0];
    }
}

