/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectAdapter;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectListener;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.IContentExtension;
import org.eclipse.ui.IActionFilter;

public abstract class ContentExtensionBase
extends PlatformObject
implements IContentExtension {
    private IConnectionProfile mConnectionProfile;
    private IConnectListener mProfileConnectListener = new ConnectAdapter(){

        public void openConnection(ConnectEvent event) throws CoreException {
            Throwable exception;
            ContentExtensionBase.this.openConnection();
            IConnection connection = ContentExtensionBase.this.getConnection();
            if (connection != null && (exception = connection.getConnectException()) != null) {
                ContentExtensionBase.this.closeConnection();
                throw new CoreException((IStatus)new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), 10001, ConnectivityUIPlugin.getDefault().getResourceString("error.contentExtension", new String[]{ContentExtensionBase.this.getLabel(), ContentExtensionBase.this.getConnectionProfile().getName(), exception.getMessage()}), exception));
            }
        }

        public void closeConnection(ConnectEvent event) throws CoreException {
            ContentExtensionBase.this.closeConnection();
        }
    };
    static /* synthetic */ Class class$0;

    public ContentExtensionBase(IConnectionProfile profile) {
        this.mConnectionProfile = profile;
        this.mConnectionProfile.addConnectListener(this.mProfileConnectListener);
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mConnectionProfile;
    }

    public abstract void openConnection();

    public abstract void closeConnection();

    public abstract IConnection getConnection();

    public void dispose() {
        this.closeConnection();
        this.getConnectionProfile().removeConnectListener(this.mProfileConnectListener);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IActionFilter(){

                public boolean testAttribute(Object target, String name, String value) {
                    if (target == null || !(target instanceof IContentExtension)) {
                        return false;
                    }
                    if (name.equals("org.eclipse.datatools.connectivity.contentextension.state")) {
                        return ContentExtensionBase.this.getConnection() != null && ContentExtensionBase.this.getConnection().getConnectException() != null;
                    }
                    return false;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public boolean isVisible() {
        return true;
    }
}

