/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPResponse;
import org.eclipse.datatools.enablement.oda.ws.util.CompositeInputStream;
import org.eclipse.datatools.enablement.oda.ws.util.SOAPFaultParser;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;

public class RawMessageSender {
    private String spec = "";
    private String message = "";
    private String soapAction = "";
    private SOAPResponse soapResponse;
    private HttpURLConnection connection;

    public RawMessageSender(String spec, String message, String soapAction) {
        this.spec = spec;
        this.message = message;
        this.soapAction = soapAction;
    }

    public RawMessageSender() {
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public SOAPResponse getSOAPResponse(long timeout) throws OdaException {
        SOAPResponseCollector collector = new SOAPResponseCollector();
        Thread t = new Thread(collector);
        t.start();
        try {
            timeout = timeout == 0L ? 0L : Math.max(60000L, timeout);
            t.join(timeout);
        }
        catch (InterruptedException interruptedException) {}
        if (collector.getException() != null) {
            throw new OdaException(collector.getException().getMessage());
        }
        return this.soapResponse;
    }

    private InputStream getSOAPResponseStream(InputStream connectionStream) throws IOException, OdaException {
        byte[] buffer = new byte[4000];
        int pos = 0;
        int readLen = 1;
        do {
            if ((readLen = connectionStream.read(buffer, pos, buffer.length - pos)) == -1) continue;
            pos += readLen;
        } while (readLen >= 0 && pos < buffer.length);
        if (pos == 0) {
            return connectionStream;
        }
        if (pos < buffer.length) {
            ByteArrayInputStream faultStream = new ByteArrayInputStream(buffer, 0, pos);
            SOAPFaultParser parser = new SOAPFaultParser();
            parser.parse(faultStream);
            if (parser.isSoapFault()) {
                throw new OdaException(String.valueOf(parser.getErrorMessage()) + '\n' + new String(buffer, 0, pos));
            }
            byte[] buffer1 = new byte[pos];
            System.arraycopy(buffer, 0, buffer1, 0, pos);
            return new CompositeInputStream(buffer1, connectionStream);
        }
        return new CompositeInputStream(buffer, connectionStream);
    }

    class SOAPResponseCollector
    implements Runnable {
        private Exception e = null;

        SOAPResponseCollector() {
        }

        Exception getException() {
            return this.e;
        }

        public void run() {
            try {
                this.e = null;
                URL url = new URL(RawMessageSender.this.spec);
                RawMessageSender.this.connection = (HttpURLConnection)url.openConnection();
                RawMessageSender.this.connection.setRequestMethod("POST");
                RawMessageSender.this.connection.setRequestProperty("Content-Length", String.valueOf(RawMessageSender.this.message.length()));
                RawMessageSender.this.connection.setRequestProperty("Content-Type", "text/xml");
                RawMessageSender.this.connection.setRequestProperty("Connection", "Close");
                RawMessageSender.this.connection.setRequestProperty("SoapAction", RawMessageSender.this.soapAction);
                RawMessageSender.this.connection.setDoOutput(true);
                PrintWriter pw = new PrintWriter(RawMessageSender.this.connection.getOutputStream());
                pw.write(RawMessageSender.this.message);
                pw.flush();
                RawMessageSender.this.connection.connect();
                RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.getSOAPResponseStream(RawMessageSender.this.connection.getInputStream()));
            }
            catch (MalformedURLException e) {
                if (!WSUtil.isNull(RawMessageSender.this.connection)) {
                    RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.connection.getErrorStream(), 1, e.getMessage());
                }
                this.e = e;
            }
            catch (IOException e) {
                if (!WSUtil.isNull(RawMessageSender.this.connection)) {
                    RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.connection.getErrorStream(), 1, e.getMessage());
                }
                this.e = e;
            }
            catch (OdaException e) {
                if (!WSUtil.isNull(RawMessageSender.this.connection)) {
                    RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.connection.getErrorStream(), 1, e.getMessage());
                }
                this.e = e;
            }
        }
    }
}

