/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oracle.internal.ui.drivers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.enablement.oracle.internal.ui.drivers.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class OracleThinDriverUIContributor
implements IDriverUIContributor,
Listener {
    private static final String CUI_NEWCW_DATABASE_LBL_UI_ = Messages.getString("CUI_NEWCW_DATABASE_LBL_UI_");
    private static final String CUI_NEWCW_HOST_LBL_UI_ = Messages.getString("CUI_NEWCW_HOST_LBL_UI_");
    private static final String CUI_NEWCW_PORT_LBL_UI_ = Messages.getString("CUI_NEWCW_PORT_LBL_UI_");
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = Messages.getString("CUI_NEWCW_USERNAME_LBL_UI_");
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = Messages.getString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    private static final String CATALOG_LBL_UI_ = Messages.getString("CATALOG_LBL_UI_");
    private static final String ALL_CATALOGS = Messages.getString("ALL_CATALOGS_OPTION_UI_");
    private static final String DBA_CATALOG = Messages.getString("DBA_CATALOG_OPTION_UI_");
    private static final String USER_CATALOG = Messages.getString("USER_CATALOG_OPTION_UI_");
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_CATALOG_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_CATALOG_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_URL_SUMMARY_DATA_TEXT_");
    private IDriverUIContributorInformation contributorInformation;
    private Label databaseLabel;
    private Text databaseText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button savePasswordButton;
    private Label urlLabel;
    private Text urlText;
    private Label catalogLabel;
    private Combo catalogCombo;
    private DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private Properties properties;
    private boolean isReadOnly = false;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"));
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PORT_REQ_UI_"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_USERID_REQ_UI_"));
            isComplete = false;
        } else if (this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_"));
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            Composite baseComposite = new Composite((Composite)this.parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            this.databaseLabel = new Label(baseComposite, 0);
            this.databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.databaseLabel.setLayoutData((Object)gd);
            this.databaseText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.databaseText.setLayoutData((Object)gd);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2060);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.urlText.setLayoutData((Object)gd);
            this.catalogLabel = new Label(baseComposite, 0);
            this.catalogLabel.setText(CATALOG_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.catalogLabel.setLayoutData((Object)gd);
            this.catalogCombo = new Combo(baseComposite, 2060);
            this.catalogCombo.setEnabled(!isReadOnly);
            this.catalogCombo.add(ALL_CATALOGS);
            this.catalogCombo.add(DBA_CATALOG);
            this.catalogCombo.add(USER_CATALOG);
            gd = new GridData();
            this.catalogCombo.setLayoutData((Object)gd);
            this.parentComposite.setContent((Control)baseComposite);
            this.parentComposite.setMinSize(baseComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    private void addListeners() {
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
        this.catalogCombo.addListener(24, (Listener)this);
    }

    private void removeListeners() {
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
        this.catalogCombo.removeListener(24, (Listener)this);
    }

    private void updateURL() {
        String url = "jdbc:oracle:thin:@" + this.hostText.getText() + ":" + this.portText.getText() + ":" + this.databaseText.getText();
        this.urlText.setText(url);
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_CATALOG_SUMMARY_DATA_TEXT_, this.catalogCombo.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    public void loadProperties() {
        String savePassword;
        String password;
        this.removeListeners();
        OracleJDBCURL url = new OracleJDBCURL(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        this.databaseText.setText(url.getDatabaseName());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        String catalog = USER_CATALOG;
        String catalogSetting = this.properties.getProperty("org.eclipse.datatools.enablement.oracle.catalogType");
        if (catalogSetting != null && catalogSetting.equals("USER")) {
            catalog = USER_CATALOG;
        } else if (catalogSetting != null && catalogSetting.equals("DBA")) {
            catalog = DBA_CATALOG;
        } else if (catalogSetting != null && catalogSetting.equals("ALL")) {
            catalog = ALL_CATALOGS;
        }
        this.catalogCombo.select(this.catalogCombo.indexOf(catalog));
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    private void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        String catalog = "USER";
        String catalogSetting = this.catalogCombo.getText();
        if (catalogSetting.equals(USER_CATALOG)) {
            catalog = "USER";
        } else if (catalogSetting.equals(DBA_CATALOG)) {
            catalog = "DBA";
        } else if (catalogSetting.equals(ALL_CATALOGS)) {
            catalog = "ALL";
        }
        this.properties.setProperty("org.eclipse.datatools.enablement.oracle.catalogType", catalog);
        this.contributorInformation.setProperties(this.properties);
    }

    private class OracleJDBCURL {
        private String subprotocol = "";
        private String node = "";
        private String port = "";
        private String databaseName = "";
        private String properties = "";

        public OracleJDBCURL(String url) {
            this.parseURL(url);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        private void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 2);
                this.node = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.port = remainingURL.substring(0, remainingURL.indexOf(58));
                this.databaseName = remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
            }
            catch (Exception exception) {}
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

