/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * MemoryCacheDataSource represents the stream which can be cached in memory,
 * need not use the disk
 * 
 */
class MemoryCacheDataSource implements IInputXMLDataSource
{

	private static final int UNIT_SIZE = 100000;
	private byte[] byteArray;
	private boolean overReadLimit = false;
	private int currentPosition = -1, totalSize = 0, currentListIndex = -1, currentArrayPosition = -1;
	private List byteList;

	/**
	 * 
	 * @param stream
	 * @param size
	 */
	MemoryCacheDataSource( InputStream stream, long size )
	{
		byteList = new ArrayList( );
	
		byteArray = new byte[UNIT_SIZE];
		byteList.add( byteArray );

		int ch = -1;
		try
		{
			int i = 0;
			for ( ; totalSize < size && ( ch = stream.read( ) ) != -1; i++ )
			{
				if( i>= UNIT_SIZE )
				{
					byteArray = new byte[UNIT_SIZE];
					byteList.add( byteArray );
					i = 0; 
				}
				totalSize++;
				byteArray[i] = (byte)ch;
			}
		}
		catch ( IOException e )
		{
		}
		if ( ch != -1 )
			overReadLimit = true;
	}

	/**
	 * 
	 * @return
	 */
	boolean canUseMemoryCache( )
	{
		return !this.overReadLimit;
	}
	
	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#read()
	 */
	public int read( )
	{
		currentPosition++;
		currentArrayPosition++;
		if ( currentPosition < totalSize )
		{
			if( currentArrayPosition >= UNIT_SIZE || currentArrayPosition == 0 )
			{
				currentArrayPosition = 0;
				currentListIndex++;
				if ( currentListIndex < this.byteList.size( ) ) 
				{
					byteArray = ( byte[] ) this.byteList.get( currentListIndex );
				}
				else
				{
					return -1;
				}
			}
			return byteArray[currentArrayPosition];
		}
		else
			return -1;
	}

	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#init()
	 */
	public void init( )
	{
		this.currentPosition = -1;
		this.currentArrayPosition = -1;
		this.currentListIndex = -1;
	}

	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#close()
	 */
	public void close( ) throws IOException
	{
	}
}
