/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *     IBM Corporation - converted to AbstractAction
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.popup.actions;

import java.util.Iterator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.GroupID;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.sqltools.tablewizard.ui.Messages;
import org.eclipse.datatools.sqltools.tablewizard.ui.TableDefinitionUIPlugin;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.UIUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

import org.eclipse.ui.actions.WorkspaceModifyOperation;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.emf.ecore.EObject;

/**
 * @author yuanying
 * 
 */
public class DeleteTableWizardAction extends AbstractAction {

	private static final String TEXT = Messages.getString("table.delete.menu");
	
	public void selectionChanged(SelectionChangedEvent event)
    {
        super.selectionChanged(event);

        if (event.getSelection() instanceof IStructuredSelection
                && ((IStructuredSelection) event.getSelection()).getFirstElement() instanceof EObject)
        {
            EObject o = (EObject) ((IStructuredSelection) event.getSelection()).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            String groupID = containmentService.getGroupId(o);
            setEnabled((groupID != null) && (groupID.startsWith(GroupID.CORE_PREFIX)));
        }
    }
	
	public void initialize()
    {
        initializeAction(null, null, TEXT, TEXT);
    }
	
	public void run()
    {
		if (!this.event.getSelection().isEmpty())
        {
            Iterator iter = ((IStructuredSelection) event.getSelection()).iterator();
            Object selectedObj = iter.next();
            
            if (selectedObj instanceof PersistentTable)
            {            	
            	Database db = getDatabase(((PersistentTable)selectedObj).getSchema());
            	ConnectionInfo conInfo = (ConnectionInfo)DatabaseConnectionRegistry.getConnectionForDatabase(db);
            	final IConnectionProfile profile = conInfo.getConnectionProfile();
            	final PersistentTable table = (PersistentTable)selectedObj;
            	try
            	{
            		deleteTable(profile, table);
            	}
	            catch (Exception e) 
	            {	            	
	            	throw new RuntimeException(e);
	    		}
            }
        }            
    }
	
	private Database getDatabase (Schema schema)
    {
        return schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
    }
	
	/**
	 * @param profile
	 * @param table
	 */
	private void deleteTable(final IConnectionProfile profile,
			final PersistentTable table) throws Exception {
		final Database db = table.getSchema().getDatabase() != null?
						table.getSchema().getDatabase():table.getSchema().getCatalog().getDatabase();
		final DatabaseDefinition databaseDefinition = RDBCorePlugin
				.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);

		WorkspaceModifyOperation operation = new WorkspaceModifyOperation() {
			protected void execute(IProgressMonitor monitor) {
				try {
					String[] sqls = createDeleteSql(table, databaseDefinition,
							monitor);
					UIUtils.openSQLEditor(profile, db, sqls, monitor);
				} catch (Exception e) {
					System.out.println(e.getMessage());
				} finally {
					monitor.done();
				}
			}
		};

		TableDefinitionUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().run(false,
				false, operation);
	}
	
	/**
	 * 
	 * @param table
	 * @param databaseDefinition
	 * @param monitor
	 * @return
	 */
	protected String[] createDeleteSql(PersistentTable table,
			DatabaseDefinition databaseDefinition, IProgressMonitor monitor) 
	{
		DDLGenerator generator = databaseDefinition.getDDLGenerator();
		// TODO consider option.
		return generator.dropSQLObjects(new SQLObject[] { table }, false,
				false, monitor);
	}
}
