/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *     IBM Corp.- Modified to extend AbstractAction to work with NavigatorContent
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.popup.actions;

import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.GroupID;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.ITableNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.ConnectionUtil;
import org.eclipse.datatools.sqltools.tablewizard.ui.Messages;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizards.GenericTableDefinitionWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class NewTableWizardAction extends AbstractAction
{
	private static final String TEXT = Messages.getString("table.create.menu");
	
	public void selectionChanged(SelectionChangedEvent event)
    {
        super.selectionChanged(event);

        if (event.getSelection() instanceof IStructuredSelection
                && ((IStructuredSelection) event.getSelection()).getFirstElement() instanceof EObject)
        {
            EObject o = (EObject) ((IStructuredSelection) event.getSelection()).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            String groupID = containmentService.getGroupId(o);
            setEnabled((groupID != null) && (groupID.startsWith(GroupID.CORE_PREFIX)));
        }
    }
	
	public void initialize()
    {
        initializeAction(null, null, TEXT, TEXT);
    }
	
	public void run()
    {
		if (!this.event.getSelection().isEmpty())
        {
			try {
				Display display = Display.getCurrent();
				Object o = ((IStructuredSelection) event.getSelection()).getFirstElement();
				if (o instanceof ITableNode)
				{
					ITableNode node = (ITableNode)o;
					Object parent = node.getParent();
					if (parent instanceof Schema) {
					    Schema schema = (Schema) parent;
					    ConnectionInfo info = ConnectionUtil.getConnectionForEObject(schema);
					    if (info != null) {
					        IConnectionProfile profile = info.getConnectionProfile();
					        GenericTableDefinitionWizard wizard = new GenericTableDefinitionWizard(profile, schema);
					        WizardDialog dialog = new WizardDialog(display.getActiveShell(), wizard);
					        dialog.create();
					        dialog.getShell().pack();
					        dialog.open();
					    }
					}
				}
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
        }
    }
}