/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.utils;

import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

/**
 * TODO change name to NotifyingListContentProvider, and change implementation.
 * @author yuanying
 * 
 */
public class EObjectListPropertyContentProvider implements
		IStructuredContentProvider {

	private Viewer viewer;
	private EObject target;

	private int featureID;
	
	private Adapter listChangeListener = new AdapterImpl() {
		public void notifyChanged(Notification msg) {
			if (viewer.getControl().isDisposed()) {
				return;
			}
			if (!(featureID == msg.getFeatureID(msg.getNotifier().getClass()))) {
				return;
			}
			switch (msg.getEventType()) {
			case Notification.ADD:
				if (viewer instanceof AbstractListViewer) {
					((AbstractListViewer) viewer).add(msg.getNewValue());
				} else {
					((TableViewer) viewer).insert(msg.getNewValue(), msg.getPosition());
				}
				break;
			case Notification.ADD_MANY:
				// FIXME implement here
				break;
			case Notification.REMOVE:
				if (viewer instanceof AbstractListViewer) {
					((AbstractListViewer) viewer).remove(msg.getOldValue());
				} else {
					((TableViewer) viewer).remove(msg.getOldValue());
				}
				break;
			case Notification.REMOVE_MANY:
				// FIXME implement here
				break;
			default:
			}
		}
	};

	/**
	 * @param featureID
	 */
	public EObjectListPropertyContentProvider(int featureID) {
		this.featureID = featureID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		EStructuralFeature feature = EObjectUtils.computeStructualFeature(this.target,
				this.featureID);
		Object elements = this.target.eGet(feature);
		if (elements instanceof List) {
			return ((List) elements).toArray();
		}
		return new Object[] { elements };
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		this.target.eAdapters().remove(this.listChangeListener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		this.viewer = viewer;

		if (!(viewer instanceof TableViewer || viewer instanceof AbstractListViewer)) {
			throw new IllegalArgumentException(
					"This content provider only works with TableViewer or AbstractListViewer"); //$NON-NLS-1$
		}

		if (newInput != null && !(newInput instanceof EObject)) {
			throw new IllegalArgumentException(
					"This content provider only works with input of type EObject"); //$NON-NLS-1$
		}

		this.setInput((EObject) newInput);
	}

	private void setInput(EObject target) {
		if (target == null) {
			return;
		}
		if (target != null) {
			target.eAdapters().remove(this.listChangeListener);
		}
		
		this.target = target;
		this.target.eAdapters().add(this.listChangeListener);
	}
}
