/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.utils;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

/**
 * 
 * @author yuanying
 * 
 */
public class EObjectListPropertyLabelProvider extends LabelProvider implements
		ILabelProvider, ITableLabelProvider {

	private EObject target;
	final private int featureID;
	final private int[] childFeatureIDs;

	private Adapter propertyListener = new AdapterImpl() {
		public void notifyChanged(Notification msg) {
			for (int i = 0; i < childFeatureIDs.length; i++) {
				if (childFeatureIDs[i] == msg.getFeatureID(msg.getNotifier()
						.getClass())) {
					fireLabelProviderChanged(new LabelProviderChangedEvent(
							EObjectListPropertyLabelProvider.this)/*
																	 * TODO ,
																	 * source
																	 */);
				}
			}
		}
	};

	private AdapterFactory propertyListenerFactory = new AdapterFactoryImpl() {
		protected Adapter createAdapter(Notifier target, Object type) {
			return propertyListener;
		}

		public boolean isFactoryForType(Object type) {
			return type == propertyListener;
		}
	};

	private Adapter listChangeListener = new AdapterImpl() {
		public void notifyChanged(Notification msg) {
			if (!(featureID == msg.getFeatureID(msg.getNotifier().getClass()))) {
				return;
			}
			switch (msg.getEventType()) {
			case Notification.ADD:
				if (msg.getNewValue() instanceof Notifier) {
					propertyListenerFactory.adapt((Notifier) msg.getNewValue(),
							propertyListener);
				}
				break;
			case Notification.ADD_MANY:
				// FIXME implement here
				break;
			case Notification.REMOVE:
				if (msg.getNewValue() instanceof Notifier) {
					((Notifier) msg.getOldValue()).eAdapters().remove(
							propertyListener);
				}
				break;
			case Notification.REMOVE_MANY:
				// FIXME implement here
				break;
			}
		}
	};

	/**
	 * 
	 * @param target
	 * @param featureID
	 * @param childFeatureIDs
	 */
	public EObjectListPropertyLabelProvider(EObject target, int featureID,
			int[] childFeatureIDs) {
		this.childFeatureIDs = childFeatureIDs;
		this.featureID = featureID;
		this.setTarget(target);
	}

	/**
	 * 
	 * @return
	 */
	public int[] getChildFeatureIDs() {
		return childFeatureIDs;
	}

	/**
	 * 
	 * @param target
	 * @param featureID
	 * @param childFeatureIDs
	 */
	public EObjectListPropertyLabelProvider(EObject target, int featureID,
			int childFeatureIDs) {
		this(target, featureID, new int[] { childFeatureIDs });
	}

	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
		return getColumnText(element, 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
	 *      int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof EObject) {
			EObject obj = (EObject) element;
			if (columnIndex < childFeatureIDs.length) {
				Object result = obj.eGet(EObjectUtils.computeStructualFeature(
						obj, childFeatureIDs[columnIndex]));
				return result == null ? "" : result.toString(); //$NON-NLS-1$
			}
		}
		return null;
	}

	/**
	 * 
	 * @param target
	 */
	public void setTarget(EObject target) {
		if (this.target != null) {
			this.target.eAdapters().remove(this.listChangeListener);
		}
		this.target = target;
		if (this.target != null) {
			this.target.eAdapters().add(this.listChangeListener);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.BaseLabelProvider#dispose()
	 */
	public void dispose() {
		if (this.target != null) {
			this.target.eAdapters().remove(this.listChangeListener);
		}
		// TODO remove propertyListener from children.
		super.dispose();
	}
}
